<?php
/**
 * @package Noo_Posttype
 */
/*
Plugin Name: Noo Post Type
Plugin URI: http://nootheme.com/
Description: This is plugin for NooTheme. This plugin allows you to create post types, taxonomies
Version: 1.0.0
Author: NooTheme
Author URI: http://nootheme.com/
License: GPLv2 or later
*/


/**
 * This is the Noo Posttype loader class.
 *
 * @package   Noo_Posttype
 * @author    nootheme (http:://nootheme.com)
 * @copyright Copyright (c) 2014, NooTheme
 */

if ( !class_exists('Noo_Post_Type') ):

    class Noo_Post_Type{

        /*
         * This method loads other methods of the class.
         */
        public function __construct(){
            /* load languages */
            $this -> load_languages();

            /*load all nootheme*/
            $this -> load_nootheme();
        }

        /*
         * Load the languages before everything else.
         */
        private function load_languages(){
            add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
        }

        /*
         * Load the text domain.
         */
        public function load_textdomain(){

            load_plugin_textdomain( NOO_DOMAIN, false, plugin_dir_url( __FILE__ ) . '/languages' );
        }

        /*
         * Load Nootheme on the 'after_setup_theme' action. Then filters will
         */
        public function load_nootheme(){

            $this -> constants();

            $this -> admin_includes();


        }

        /**
         * Constants
         */
        private function constants(){

            define('NOO_DOMAIN', 'noo-posttype');

            define('PLUGIN_PATH', plugin_dir_url( __FILE__ ));

            define('PLUGIN_SERVER_PATH',dirname( __FILE__ ) );
        }

        /*
         * Require file
         */
        private function  admin_includes(){
            require_once PLUGIN_SERVER_PATH.'/admin/post-type/function-init.php';
        }


    }
    $oj_nooplugin = new Noo_Post_Type();

endif;

?>