<?php
if(!class_exists('NooPropertyFilterDropdown')):
class NooAlbumFilterDropdown extends Walker {

	var $tree_type = 'category';
	var $db_fields = array ('parent' => 'parent', 'id' => 'term_id', 'slug' => 'slug' );

	public function start_el( &$output, $cat, $depth = 0, $args = array(), $current_object_id = 0 ) {

		if ( ! empty( $args['hierarchical'] ) )
			$pad = str_repeat('-', $depth * 2);
		else
			$pad = '';

		$cat_name = $cat->name;

		$value = isset( $args['value'] ) && $args['value'] == 'id' ? $cat->term_id : $cat->slug;

		$output .= "\t<option class=\"level-$depth\" value=\"" . $value . "\"";

		if ( $value == $args['selected'] || ( is_array( $args['selected'] ) && in_array( $value, $args['selected'] ) ) )
			$output .= ' selected="selected"';

		$output .= '>';

		$output .= $pad . $cat_name;

		if ( ! empty( $args['show_count'] ) )
			$output .= '&nbsp;(' . $cat->count . ')';

		$output .= "</option>\n";
	}

	public function display_element( $element, &$children_elements, $max_depth, $depth = 0, $args, &$output ) {
		if ( ! $element || 0 === $element->count ) {
			return;
		}
		parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
}
endif;

if ( ! class_exists( 'Noo_Back_Album' ) ) :

	class Noo_Back_Album {

		public function __construct() {
			add_action( 'init', array( &$this, 'register_post_type' ));
			if ( is_admin() ) {
				add_action( 'restrict_manage_posts', array( $this, 'restrict_manage_posts' ) );
				//Album
				add_filter( 'manage_edit-noo_album_columns', array($this,'album_columns') );
				add_filter( 'manage_noo_album_posts_custom_column',  array($this,'album_column'), 2 );
				add_action( 'add_meta_boxes', array( &$this, 'add_meta_boxes' ), 30 );
				add_action( 'save_post', array( &$this, 'noo_save_song_meta_box'),1,2 );
				add_action ( 'admin_enqueue_scripts', array( &$this,'admin_enqueue_scripts' ));
				add_action( 'admin_init', array( &$this, 'permalink_setting' ) );
				add_action( 'admin_init', array( &$this, 'permalink_setting_save' ) );
			}
		}
		
		public function restrict_manage_posts(){
			global $typenow, $wp_query;
			switch ( $typenow ) {
				case 'noo_album' :
					$this->album_filters();
					break;
			}
		}
		public function album_filters(){
			global $wp_query;
			$album_genre = isset( $wp_query->query['album_genre'] ) ? $wp_query->query['album_genre'] : '';
			wp_dropdown_categories(array(
				'taxonomy'=>'album_genre',
				'name'=>'album_genre',
				'echo'=>true,
				'show_count'=>true,
				'show_option_none'=>__('Select a Genre','noo'),
				'option_none_value'=>0,
				'selected'=>$album_genre,
				'walker'=>new NooAlbumFilterDropdown
			));
				
				
			$album_artist = isset( $wp_query->query['album_artist'] ) ? $wp_query->query['album_artist'] : '';
			wp_dropdown_categories(array(
				'taxonomy'=>'album_artist',
				'name'=>'album_artist',
				'echo'=>true,
				'show_count'=>true,
				'show_option_none'=>__('Select a Artist','noo'),
				'option_none_value'=>0,
				'selected'=>$album_artist,
				'walker'=>new NooAlbumFilterDropdown
			));
				
			$album_produced = isset( $wp_query->query['album_produced'] ) ? $wp_query->query['album_produced'] : '';
			wp_dropdown_categories(array(
				'taxonomy'=>'album_produced',
				'name'=>'album_produced',
				'echo'=>true,
				'show_count'=>true,
				'show_option_none'=>__('Select a Produced','noo'),
				'option_none_value'=>0,
				'hierarchical'=>true,
				'selected'=>$album_produced,
				'walker'=>new NooAlbumFilterDropdown()
			));
		
		}
		
		public function album_columns( $existing_columns ) {
			if ( empty( $existing_columns ) && ! is_array( $existing_columns ) ) {
				$existing_columns = array();
			}
	
			unset( $existing_columns['title'], $existing_columns['comments'], $existing_columns['date'] );
	
			$columns          = array();
			$columns['cb']    = '<input type="checkbox" />';
			$columns['name']  = __( 'Name', 'noo' );
	
			$columns['album_genre']  = __( 'Genre', 'noo' );
			$columns['album_artist']  = __( 'Artist', 'noo' );
			$columns['album_produced']  = __( 'Produced', 'noo' );
			$columns['album_tag']  = __( 'Tags', 'noo' );
			$columns['date']         = __( 'Date', 'noo' );
	
			return array_merge( $columns, $existing_columns );
				
		}
		
		public function album_column($column){
			global $post;
			switch ( $column ) {
				case 'name' :
					$edit_link        = get_edit_post_link( $post->ID );
					$title            = _draft_or_post_title();
					$post_type_object = get_post_type_object( $post->post_type );
					$can_edit_post    = current_user_can( $post_type_object->cap->edit_post, $post->ID );
			
					echo '<strong><a class="row-title" href="' . esc_url( $edit_link ) .'">' . $title.'</a>';
			
					_post_states( $post );
			
					echo '</strong>';
			
					if ( $post->post_parent > 0 ) {
						echo '&nbsp;&nbsp;&larr; <a href="'. get_edit_post_link( $post->post_parent ) .'">'. get_the_title( $post->post_parent ) .'</a>';
					}
			
					// Excerpt view
					if ( isset( $_GET['mode'] ) && 'excerpt' == $_GET['mode'] ) {
						echo apply_filters( 'the_excerpt', $post->post_excerpt );
					}
			
					// Get actions
					$actions = array();
			
					$actions['id'] = 'ID: ' . $post->ID;
			
					if ( $can_edit_post && 'trash' != $post->post_status ) {
						$actions['edit'] = '<a href="' . get_edit_post_link( $post->ID, true ) . '" title="' . esc_attr( __( 'Edit this item', 'noo' ) ) . '">' . __( 'Edit', 'noo' ) . '</a>';
						$actions['inline hide-if-no-js'] = '<a href="#" class="editinline" title="' . esc_attr( __( 'Edit this item inline', 'noo' ) ) . '">' . __( 'Quick&nbsp;Edit', 'noo' ) . '</a>';
					}
					if ( current_user_can( $post_type_object->cap->delete_post, $post->ID ) ) {
						if ( 'trash' == $post->post_status ) {
							$actions['untrash'] = '<a title="' . esc_attr( __( 'Restore this item from the Trash', 'noo' ) ) . '" href="' . wp_nonce_url( admin_url( sprintf( $post_type_object->_edit_link . '&amp;action=untrash', $post->ID ) ), 'untrash-post_' . $post->ID ) . '">' . __( 'Restore', 'noo' ) . '</a>';
						} elseif ( EMPTY_TRASH_DAYS ) {
							$actions['trash'] = '<a class="submitdelete" title="' . esc_attr( __( 'Move this item to the Trash', 'noo' ) ) . '" href="' . get_delete_post_link( $post->ID ) . '">' . __( 'Trash', 'noo' ) . '</a>';
						}
			
						if ( 'trash' == $post->post_status || ! EMPTY_TRASH_DAYS ) {
							$actions['delete'] = '<a class="submitdelete" title="' . esc_attr( __( 'Delete this item permanently', 'noo' ) ) . '" href="' . get_delete_post_link( $post->ID, '', true ) . '">' . __( 'Delete Permanently', 'noo' ) . '</a>';
						}
					}
					if ( $post_type_object->public ) {
						if ( in_array( $post->post_status, array( 'pending', 'draft', 'future' ) ) ) {
							if ( $can_edit_post )
								$actions['view'] = '<a href="' . esc_url( add_query_arg( 'preview', 'true', get_permalink( $post->ID ) ) ) . '" title="' . esc_attr( sprintf( __( 'Preview &#8220;%s&#8221;', 'noo' ), $title ) ) . '" rel="permalink">' . __( 'Preview', 'noo' ) . '</a>';
						} elseif ( 'trash' != $post->post_status ) {
							$actions['view'] = '<a href="' . get_permalink( $post->ID ) . '" title="' . esc_attr( sprintf( __( 'View &#8220;%s&#8221;', 'noo' ), $title ) ) . '" rel="permalink">' . __( 'View', 'noo' ) . '</a>';
						}
					}
			
					$actions = apply_filters( 'post_row_actions', $actions, $post );
			
					echo '<div class="row-actions">';
			
					$i = 0;
					$action_count = sizeof( $actions );
			
					foreach ( $actions as $action => $link ) {
						++$i;
						( $i == $action_count ) ? $sep = '' : $sep = ' | ';
						echo '<span class="' . $action . '">' . $link . $sep . '</span>';
					}
					echo '</div>';
			
					get_inline_data( $post );
			
					break;
				
				case 'album_genre' :
				case 'album_artist' :
				case 'album_produced':
				case 'album_tag':
					if ( ! $terms = get_the_terms( $post->ID, $column ) ) {
						echo '<span class="na">&ndash;</span>';
					} else {
						$termlist = array();
						foreach ( $terms as $term ) {
							$termlist[] = '<a href="' . admin_url( 'edit.php?' . $column . '=' . $term->slug . '&post_type=product' ) . ' ">' . $term->name . '</a>';
						}
			
						echo implode( ', ', $termlist );
					}
					break;
				default :
					break;
			}
		}

		public static function songs_to_playlist_data($post_id){
			$songs = get_post_meta( get_the_ID(), '_noo_songs', true );
			$song_arr = array();
			if($songs):
				if(has_post_thumbnail($post_id)){
					$thumb       = get_the_post_thumbnail( $post_id, 'thumbnail', array(
						'title' => esc_attr( get_the_title( get_post_thumbnail_id($post_id) ) )
						) );
				}else{
					$thumb = '<img src="'.get_template_directory_uri().'/assets/images/no-track-image.png">';
				}
				foreach ($songs as $k=>$song){

					$song_obj = new stdClass();
					$song_obj->id = $k;
					$song_obj->album_id = $post_id;
					$song_obj->artist = get_the_term_list($post_id,'album_artist');
					if( isset($song['author']) && !empty($song['author']) ) {
						$song_obj->artist = '<a href="javascript:void(0)">' . $song['author'] . '</a>';
					}
					$song_obj->genre = get_the_term_list($post_id,'album_genre');
					$song_obj->file = $song['file'];
					$song_obj->thumb = $thumb;
					$song_obj->name = esc_html( $song['name'] );
					$song_obj->url = get_permalink($post_id);
					$song_obj->album = get_the_title($post_id);
					$song_arr[] = $song_obj;
				}
			endif;
			return json_encode($song_arr);
		}


		public function admin_enqueue_scripts(){
			wp_register_style( 'noo-album-admin', PLUGIN_PATH . '/assets/css/album.css' );
			wp_enqueue_style( 'noo-album-admin' );
			if(function_exists( 'wp_enqueue_media' )){
				wp_enqueue_media();
			}else{
				wp_enqueue_style('thickbox');
				wp_enqueue_script('media-upload');
				wp_enqueue_script('thickbox');
			}
			wp_register_script( 'noo-album-admin', PLUGIN_PATH . '/assets/js/album.js', array('jquery'), null, true );
			wp_enqueue_script( 'noo-album-admin' );
		}


		public function add_meta_boxes() {
			$prefix = '_noo_album';
			$helper = new NOO_Meta_Boxes_Helper($prefix, array(
				'page' => 'noo_album'
			));
			$meta_box = array(
				'id' => "{$prefix}_meta_box_purchase",
				'title' => __('Purchase Link Setting', 'noo') ,
				'fields' => array(
					array(
						'label' => __('iTunes', 'noo') ,
						'id' => "_itunes_url",
						'type' => 'text',
					),
			
					array(
						'label' => __('Amazon', 'noo') ,
						'id' => "_amazon_url",
						'type' => 'text',
					),
					array(
						'label' => __('Beatport', 'noo') ,
						'id' => "_beatport_url",
						'type' => 'text',
					),
				)
			);
			$helper->add_meta_box($meta_box);
			$meta_box = array(
				'id' => "{$prefix}_meta_box_page",
				'title' => __('Songs setting', 'noo') ,
				'fields' => array(
					array(
						'label' => __('Release date', 'noo') ,
						'id' => "_release_date",
						'type' => 'datepicker',
					),
					array(
						'id' => "_songs",
						'type' => 'song',
						'callback'=>array(&$this,'noo_song_meta_box_callback'),
					),
				)
			);
			$helper->add_meta_box($meta_box);
			
		}
		
		public function noo_song_meta_box_row($song){
			ob_start();
			?>
			<tr>
				<td class="sort"></td>
				<td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'File Name', 'noo' ); ?>" name="_noo_song_names[]" value="<?php if( isset($song['name']) && $song['name'] !='' ): echo esc_attr($song['name']); endif; ?>" /></td>
                <td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'File Author', 'noo' ); ?>" name="_noo_song_authors[]" value="<?php if( isset($song['author']) && $song['author'] !='' ): echo esc_attr($song['author']); endif; ?>" /></td>
                <td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'Link Itune', 'noo' ); ?>" name="_noo_song_itunes[]" value="<?php if( isset($song['itune']) && $song['itune'] !='' ): echo esc_attr($song['itune']); endif; ?>" /></td>
                <td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'Link Amazon', 'noo' ); ?>" name="_noo_song_amazons[]" value="<?php if( isset($song['amazon']) && $song['amazon'] !='' ): echo esc_attr($song['amazon']); endif; ?>" /></td>
                <td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'Link Beatport', 'noo' ); ?>" name="_noo_song_beatports[]" value="<?php if( isset($song['beatport']) && $song['beatport'] !='' ): echo esc_attr($song['beatport']); endif; ?>" /></td>
                <td class="file_name"><input type="text" class="input_text" placeholder="<?php _e( 'Link Soundcloud', 'noo' ); ?>" name="_noo_song_soundclouds[]" value="<?php if( isset($song['soundcloud']) && $song['soundcloud'] !='' ): echo esc_attr($song['soundcloud']); endif; ?>" /></td>
                <td class="file_name">
                    <select name="_noo_song_downloads[]">
                        <option value="0" <?php if( isset($song['download']) && $song['download'] == 0): echo 'selected';  endif ?>><?php _e('No','noo'); ?></option>
                        <option value="1" <?php if(isset($song['download']) && $song['download'] == 1): echo 'selected';  endif ?>><?php _e('Yes','noo'); ?></option>
                    </select>
                </td>
				<td class="file_url"><input type="text" class="input_text" placeholder="<?php _e( "http://", 'noo' ); ?>" name="_noo_song_urls[]" value="<?php echo $song['file']?>" /></td>
				<td class="file_url_choose" width="1%"><a href="#" class="button upload_song_button" data-choose="<?php _e( 'Choose file', 'noo' ); ?>" data-update="<?php _e( 'Insert file URL', 'noo' ); ?>"><?php echo str_replace( ' ', '&nbsp;', __( 'Choose file', 'noo' ) ); ?></a></td>
				<td width="1%"><a href="#" class="delete"><?php _e( 'Delete', 'noo' ); ?></a></td>
			</tr>
			<?php
			return ob_get_clean();
		}
		
		public function noo_song_meta_box_callback( $post, $id, $type, $meta, $std, $field){
		
			?>
			<style>
			.noo-form-group._songs .noo-control {
				width:100%;
			}
			</style>
			<div class="noo-song-meta-box" style="margin-top: 20px">
				<strong><?php _e('Songs:','noo')?></strong><br>
				<?php wp_nonce_field( '_noo_song_meta_box_save', '_noo_song_meta_box_nonce' ); ?>
				<table class="widefat">
					<thead>
						<tr>
							<th class="sort">&nbsp;</th>
							<th><?php _e( 'Name', 'noo' ); ?> </th>
                            <th><?php _e( 'Author', 'noo' ); ?> </th>
                            <th><?php _e( 'Itune', 'noo' ); ?> </th>
                            <th><?php _e( 'Amazon', 'noo' ); ?> </th>
                            <th><?php _e( 'Beatport', 'noo' ); ?> </th>
                            <th><?php _e( 'Soundcloud', 'noo' ); ?> </th>
                            <th><?php _e( 'Download', 'noo' ); ?> </th>
							<th colspan="2"><?php _e( 'File URL', 'noo' ); ?></th>
							<th>&nbsp;</th>
						</tr>
					</thead>
					<tbody>
						<?php
						$songs = get_post_meta( $post->ID, '_noo_songs', true );
						if($songs){
							foreach ((array)$songs as $song):
								echo $this->noo_song_meta_box_row($song);
							endforeach;
						}
						?>
					</tbody>
					<tfoot>
						<tr>
							<th colspan="5">
								<a href="#" class="button insert" data-row="<?php echo esc_attr($this->noo_song_meta_box_row(array('name'=>'','author'=>'', 'itune'=>'', 'amazon'=>'', 'beatport'=>'', 'soundcloud'=>'','download'=>'','file'=>''))); ?>"><?php _e( 'Add Song', 'noo' ); ?></a>
							</th>
						</tr>
					</tfoot>
				</table>
			</div>
			<?php
		}
		
		function noo_save_song_meta_box($post_id, $post){
		
			if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {
				return;
			}
		
			if ( ! isset( $_POST['_noo_song_meta_box_nonce'] ) || ! isset( $_POST['_noo_song_meta_box_nonce'] ) || ! wp_verify_nonce( $_POST['_noo_song_meta_box_nonce'], '_noo_song_meta_box_save' ) )
				return;
			// Check the post being saved == the $post_id to prevent triggering this call for other save_post events
			if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {
				return;
			}
			// Check user has permission to edit
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
			$songs = array();
			if ( isset( $_POST['_noo_song_urls'] ) ) {
				$song_names         = isset( $_POST['_noo_song_names'] ) ? $_POST['_noo_song_names'] : array();
                $song_authors        = isset( $_POST['_noo_song_authors'] ) ? $_POST['_noo_song_authors'] : array();
                $song_itunes         = isset( $_POST['_noo_song_itunes'] ) ? $_POST['_noo_song_itunes'] : array();
                $song_amazons        = isset( $_POST['_noo_song_amazons'] ) ? $_POST['_noo_song_amazons'] : array();
                $song_beatports      = isset( $_POST['_noo_song_beatports'] ) ? $_POST['_noo_song_beatports'] : array();
                $song_soundclouds    = isset( $_POST['_noo_song_soundclouds'] ) ? $_POST['_noo_song_soundclouds'] : array();
                $song_downloads      = isset( $_POST['_noo_song_downloads'] ) ? $_POST['_noo_song_downloads'] : array();
				$song_urls           = isset( $_POST['_noo_song_urls'] )  ? array_map( 'trim', $_POST['_noo_song_urls'] ) : array();
				$song_url_size       = sizeof( $song_urls );
		
				for ( $i = 0; $i < $song_url_size; $i ++ ) {
					if ( ! empty( $song_urls[ $i ] ) ) {
						$song_url            = ( 0 !== strpos( $song_urls[ $i ], 'http' ) ) ? sanitize_text_field( $song_urls[ $i ] ) : esc_url_raw( $song_urls[ $i ] );
						$song_name           = sanitize_text_field( $song_names[ $i ] );
                        $song_author         = sanitize_text_field( $song_authors[ $i ] );
                        $song_itune          = sanitize_text_field( $song_itunes[ $i ] );
                        $song_amazon         = sanitize_text_field( $song_amazons[ $i ] );
                        $song_beatport       = sanitize_text_field( $song_beatports[ $i ] );
                        $song_soundcloud     = sanitize_text_field( $song_soundclouds[ $i ] );
                        $song_download       = sanitize_text_field( $song_downloads[ $i ] );
						$parts 				 = pathinfo($song_url);
						$song_hash           = $post_id.'_'.wp_hash($parts['filename']);
						$songs[ $song_hash ] = array(
							'name'       => $song_name,
                            'author'     => $song_author,
                            'itune'      => $song_itune,
                            'amazon'     => $song_amazon,
                            'beatport'   => $song_beatport,
                            'soundcloud' => $song_soundcloud,
                            'download'   => $song_download,
							'file'       => $song_url
						);
					}
				}
			}
			update_post_meta( $post_id, '_noo_songs', $songs );
		}

		public function register_post_type() {
			if ( post_type_exists( 'noo_album' ) )
				return;
			
			$permalinks = get_option( 'noo_album_permalinks' );
			$album_slug = isset( $permalinks['archive_album_slug'] ) ? $permalinks['archive_album_slug'] : 'albums';
			
			register_post_type( 
				'noo_album', 
				array( 
					'labels' => array( 
						'name' => __( 'Album', 'noo' ),
						'singular_name' => __( 'Album', 'noo' ),
						'add_new' => __( 'Add New Album', 'noo' ),
						'add_new_item' => __( 'Add Album', 'noo' ),
						'edit' => __( 'Edit', 'noo' ),
						'edit_item' => __( 'Edit Album', 'noo' ),
						'new_item' => __( 'New Album', 'noo' ),
						'view' => __( 'View', 'noo' ),
						'view_item' => __( 'View Album', 'noo' ),
						'search_items' => __( 'Search Album', 'noo' ),
						'not_found' => __( 'No Albums found', 'noo' ),
						'not_found_in_trash' => __( 'No Albums found in Trash', 'noo' ),
						'parent' => __( 'Parent Album', 'noo' ) ),
					'public' => true, 
					'has_archive' => true, 
					'menu_icon' => 'dashicons-playlist-audio', 
					'rewrite' => array( 'slug' => $album_slug, 'with_front' => true ), 
					'supports' => array( 'title', 'editor', 'excerpt', 'thumbnail', 'comments', 'custom-fields' ), 
					'can_export' => true ) );
			register_taxonomy(
				'album_genre',
				'noo_album',
				array(
				'labels' => array(
					'name' => __( 'Album Genre', 'noo' ),
					'add_new_item' => __( 'Add New Album Genre', 'noo' ),
					'new_item_name' => __( 'New Album Genre', 'noo' ) ),
				'hierarchical' => true,
				'query_var' => true,
				'rewrite' => array( 'slug' => 'album-genre' ) ) );
			register_taxonomy(
				'album_artist',
				'noo_album',
				array(
				'labels' => array(
					'name' => __( 'Album Artist', 'noo' ),
					'add_new_item' => __( 'Add New Album Artist', 'noo' ),
					'new_item_name' => __( 'New Album Artist', 'noo' ) ),
				'hierarchical' => true,
				'query_var' => true,
				'rewrite' => array( 'slug' => 'album-artist' ) ) );
			
			register_taxonomy(
				'album_produced',
				'noo_album',
				array(
				'labels' => array(
					'name' => __( 'Album Produced', 'noo' ),
					'add_new_item' => __( 'Add New Album Produced', 'noo' ),
					'new_item_name' => __( 'New Album Produced', 'noo' ) ),
				'hierarchical' => true,
				'query_var' => true,
				'rewrite' => array( 'slug' => 'album-produced' ) ) );
			register_taxonomy(
				'album_tag',
				'noo_album',
				array(
					'labels' => array(
						'name' => __( 'Album Tag', 'noo' ),
						'add_new_item' => __( 'Add New Album Tag', 'noo' ),
						'new_item_name' => __( 'New Album Tag', 'noo' ) ),
					'hierarchical' => false,
					'query_var' => true,
					'rewrite' => array( 'slug' => 'album-tag' ) ) );
		}
		
		public function  permalink_setting(){
			add_settings_field(
				'archive_album_slug',      		// id
				__( 'Archive Album Base', 'noo' ), 	// setting title
				array(&$this,'archive_album_slug_input'),  		// display callback
				'permalink',                 				// settings page
				'optional'                  				// settings section
			);
		}
		
		public function archive_album_slug_input(){
			$permalinks = get_option( 'noo_album_permalinks' );
			?>
				<input name="archive_album_slug_input" type="text" class="regular-text code" value="<?php if ( isset( $permalinks['archive_album_slug'] ) ) echo esc_attr( $permalinks['archive_album_slug'] ); ?>" placeholder="<?php echo _x('albums', 'slug', 'noo') ?>" />
				<?php
			}
			
			public function permalink_setting_save(){
				if (is_admin()){
					if (isset($_POST['archive_album_slug_input'])){
							
						$archive_department_slug = sanitize_text_field( $_POST['archive_album_slug_input'] );
							
						$permalinks = get_option( 'noo_album_permalinks' );
						if ( ! $permalinks )
							$permalinks = array();
							
						$permalinks['archive_album_slug'] 	= untrailingslashit( $archive_department_slug );
							
						update_option( 'noo_album_permalinks', $permalinks );
					}
				}
				return;
			}
	}
	new Noo_Back_Album();

endif;