<?php
class noo_counter_social extends WP_Widget {

	public function __construct() {
		parent::__construct( 
			'noo_counter_social_widget',  // Base ID
			'Noo Counter Social',  // Name
			array( 'classname' => 'counter-social-widget', 'description' => __( 'Display Number counter for Social Shared.', 'noo' ) ) );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		$facebook_page = '';
		$youtube_url = '';
		$pinterest_url = '';
		$linkedin_url = '';
		$instagram_url = '';
		$google_url = '';
		$dribbble_url = '';
		$behance_url = '';
        $soundcloud_url = '';
		$vimeo_url = '';
		$twitter_info = array();
		if($instance['facebook']) {
			$facebook_page = Noo_Social_Counter::getSetting('facebook_page');
		}
		
		if($instance['twitter'] ) {
			$twitter_info['username'] = Noo_Social_Counter::getSetting('twitter_user');
			$twitter_info['consumer_key'] = Noo_Social_Counter::getSetting('twitter_consumer_key');
			$twitter_info['consumer_secret'] = Noo_Social_Counter::getSetting('twitter_consumer_secret');
			// $twitter_info['access_token'] = Noo_Social_Counter::getSetting('twitter_access_token');
			// $twitter_info['access_token_secret'] = Noo_Social_Counter::getSetting('twitter_access_token_secret');
		}

		if($instance['youtube']) {
			$youtube_url = Noo_Social_Counter::getSetting('youtube_url');
		}

		if($instance['pinterest']) {
            $pinterest_url = Noo_Social_Counter::getSetting('pinterest_url');
		}
		if($instance['linkedin']) {
			$linkedin_url = Noo_Social_Counter::getSetting('linkedin_url');
		}
		if($instance['instagram']) {
			$instagram_url = Noo_Social_Counter::getSetting('instagram_url');
			$instagram_api = Noo_Social_Counter::getSetting('instagram_api');
		}
		

		if($instance['google']) {
			$google_url = Noo_Social_Counter::getSetting('google_url');
		}
		if($instance['dribbble']) {
			$dribbble_url = Noo_Social_Counter::getSetting('dribbble_url');
		}
		if($instance['behance']) {
			$behance_url = Noo_Social_Counter::getSetting('behance_url');
			$behance_api = Noo_Social_Counter::getSetting('behance_api');
		}
		
		$new_window = isset($instance['new_window']) ? $instance['new_window'] : false;
		if(($instance['soundcloud'])) {
            $soundcloud_url = Noo_Social_Counter::getSetting('soundcloud_url');
			$soundcloud_api = Noo_Social_Counter::getSetting('soundcloud_api');
		}
		if(($instance['vimeo'])) {
			// $vimeo_url = Noo_Social_Counter::getSetting('vimeo_url');
			$vimeo_url = 'http://vimeo.com/channels/nootheme';
			
		}


		if( $new_window ) $new_window =' target="_blank" ';
		else $new_window ='';
				
		$counter = 0;
		
		?>
		<div class="widget widget-counter col3">
		<?php if ( ! empty( $instance['title'] ) ) {
			$title = apply_filters( 'widget_title', $instance['title'] );
		}
		echo $before_widget;
		if ( ! empty( $title ) ) {
			echo $before_title . $title . $after_title;
		}?>
			<ul>
			<?php if($facebook_page && $instance['facebook']):
					$facebook = noo_facebook_fans( $facebook_page ); ?>
				<li class="facebook-fans">
					<a href="<?php echo esc_url($facebook_page); ?>"<?php echo $new_window ?>>
						<i class="fa fa-facebook"></i>
						<span><?php echo @number_format( $facebook ) ?></span>
						<small><?php _e('Fans' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( !empty($twitter_info) ):
					$twitter = noo_followers_count( $twitter_info ); ?>
				<li class="twitter-followers">
					<a href="<?php echo esc_url($twitter['page_url']) ?>"<?php echo $new_window ?>>
						<i class="fa fa-twitter"></i>
						<span><?php echo @number_format($twitter['followers_count']) ?></span>
						<small><?php _e('Followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $google_url ):
					$google = noo_gplus_count( $google_url ); ?>
				<li class="google-subs">
					<a href="<?php echo esc_url($google_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-google-plus"></i>
						<span><?php echo @number_format( $google ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $behance_url ):
					$behance = noo_behance_count( $behance_url, $behance_api ); ?>
				<li class="behance-subs">
					<a href="<?php echo esc_url($behance_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-behance"></i>
						<span><?php echo @number_format( $behance ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $youtube_url ):
					$youtube = noo_youtube_subs( $youtube_url ); ?>
				<li class="youtube-subs">
					<a href="<?php echo esc_url($youtube_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-youtube"></i>
						<span><?php echo @number_format( $youtube ) ?></span>
						<small><?php _e('subscribers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $linkedin_url ):
					$linkedin = noo_linkedin_count( $linkedin_url ); ?>
				<li class="linkin-subs">
					<a href="<?php echo esc_url($linkedin_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-linkedin"></i>
						<span><?php echo @number_format( $linkedin ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $pinterest_url ):
					$pinterest = noo_pinterest_count( $pinterest_url ); ?>
				<li class="pinterest-subs">
					<a href="<?php echo esc_url($pinterest_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-pinterest"></i>
						<span><?php echo @number_format( $pinterest ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $vimeo_url ):
					$vimeo = noo_vimeo_count( $vimeo_url ); ?>
				<li class="vimeo-subs">
					<a href="<?php echo esc_url($vimeo_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-vimeo-square"></i>
						<span><?php echo @number_format( $vimeo ) ?></span>
						<small><?php _e('subscribers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>	
			<?php if( $instagram_url ):
					$instagram = noo_instagram_count( $instagram_url , $instagram_api); ?>
				<li class="instagram-subs">
					<a href="<?php echo esc_url($instagram_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-instagram"></i>
						<span><?php echo @number_format( $instagram ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $dribbble_url ):
					$dribbble = noo_dribbble_count( $dribbble_url ); ?>
				<li class="dribbble-subs">
					<a href="<?php echo esc_url($dribbble_url); ?>"<?php echo $new_window ?>>
						<i class="fa fa-dribbble"></i>
						<span><?php echo @number_format( $dribbble ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			<?php if( $soundcloud_url ):
					$soundcloud = noo_soundcloud_count( $soundcloud_url, $soundcloud_api ); ?>
				<li class="soundcround-subs">
					<a href="<?php echo esc_url($soundcloud_url);; ?>"<?php echo $new_window ?>>
						<i class="fa fa-soundcloud"></i>
						<span><?php echo @number_format( $soundcloud ) ?></span>
						<small><?php _e('followers' , 'noo' ) ?></small>
					</a>
				</li>
			<?php endif; ?>
			</ul>
		</div>
		
	<?php 
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['new_window'] = strip_tags( $new_instance['new_window'] );
		$instance['title'] = $new_instance['title'] ;
		$instance['facebook'] = $new_instance['facebook'] ;
		$instance['twitter'] =  strip_tags($new_instance['twitter']) ;
		$instance['google'] = $new_instance['google'] ;
		$instance['youtube'] = $new_instance['youtube'] ;
		$instance['pinterest'] = $new_instance['pinterest'] ;
		//$instance['flickr'] = $new_instance['flickr'] ;
		$instance['linkedin'] = $new_instance['linkedin'] ;
		$instance['instagram'] = $new_instance['instagram'] ;
		$instance['behance'] = $new_instance['behance'] ;
		$instance['soundcloud'] = $new_instance['soundcloud'] ;
		$instance['dribbble'] = $new_instance['dribbble'] ;
		$instance['vimeo'] = $new_instance['vimeo'] ;
		
		delete_transient('fans_count');
		delete_transient('twitter_count');
		delete_transient('youtube_count');
		delete_transient('google_count');
		delete_transient('pinterest_count');
		//delete_transient('flickr_count');
		delete_transient('linkedin_count');
		delete_transient('instagram_count');
		delete_transient('soundcloud_count');
		delete_transient('dribbble_count');
		delete_transient('vimeo_count');
		delete_transient('behance_count');
		

		return $instance;
	}

	function form( $instance ) { ?>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( !empty( $instance['title'] ) ) echo $instance['title']; ?>" class="widefat" type="text" />
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'noo' )?></label>
		</p>
		<p>
			<input id="<?php echo $this->get_field_id( 'new_window' ); ?>" name="<?php echo $this->get_field_name( 'new_window' ); ?>" value="true" <?php if( !empty( $instance['new_window'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'new_window' ); ?>"><?php _e( 'Open social links in a new window', 'noo' )?></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="true" <?php if( !empty( $instance['facebook'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'facebook' ); ?>"><strong><?php _e( 'Facebook', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>" value="true" <?php if( !empty( $instance['twitter'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'twitter' ); ?>"><strong><?php _e( 'Twitter', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'google' ); ?>" name="<?php echo $this->get_field_name( 'google' ); ?>" value="true" <?php if( !empty( $instance['google'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'google' ); ?>"><strong><?php _e( 'Google+', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'behance' ); ?>" name="<?php echo $this->get_field_name( 'behance' ); ?>" value="true" <?php if( !empty( $instance['behance'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'behance' ); ?>"><strong><?php _e( 'Behance', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="true" <?php if( !empty( $instance['youtube'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'youtube' ); ?>"><strong><?php _e( 'YouTube', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'linkedin' ); ?>" name="<?php echo $this->get_field_name( 'linkedin' ); ?>" value="true" <?php if( !empty( $instance['linkedin'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'linkedin' ); ?>"><strong><?php _e( 'LinkedIn', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'pinterest' ); ?>" name="<?php echo $this->get_field_name( 'pinterest' ); ?>" value="true" <?php if( !empty( $instance['pinterest'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'pinterest' ); ?>"><strong><?php _e( 'Pinterest', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'vimeo' ); ?>" name="<?php echo $this->get_field_name( 'vimeo' ); ?>" value="true" <?php if( !empty( $instance['vimeo'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'vimeo' ); ?>"><strong><?php _e( 'Vimeo', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'instagram' ); ?>" name="<?php echo $this->get_field_name( 'instagram' ); ?>" value="true" <?php if( !empty( $instance['instagram'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'instagram' ); ?>"><strong><?php _e( 'Instagram', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'soundcloud' ); ?>" name="<?php echo $this->get_field_name( 'soundcloud' ); ?>" value="true" <?php if( !empty( $instance['soundcloud'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'soundcloud' ); ?>"><strong><?php _e( 'Soundcloud', 'noo' )?></strong></label>
		</p>
		<p style="border-bottom: 1px solid #DDD;padding-bottom: 10px;">
			<input id="<?php echo $this->get_field_id( 'dribbble' ); ?>" name="<?php echo $this->get_field_name( 'dribbble' ); ?>" value="true" <?php if( !empty( $instance['dribbble'] ) ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'dribbble' ); ?>"><strong><?php _e( 'Dribbble', 'noo' )?></strong></label>
		</p>
		<?php 
	
	}


}
function noo_register_counter_widget() {
	register_widget( 'Noo_Counter_Social' );
}
add_action( 'widgets_init', 'noo_register_counter_widget' );

?>