<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$event_id = get_the_ID();
?>

<div id="tribe-events-content" class="tribe-events-single vevent hentry">

	<!-- Notices -->
	<?php tribe_events_the_notices() ?>

	<?php while ( have_posts() ) :  the_post();
        $noo_cost = tribe_get_event_meta( get_the_ID(), '_EventCost', true );
        ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class('row'); ?>>
            <div class="col-md-9">
                <div class="noo-single-event-content">
                    <?php if( isset($noo_cost) && $noo_cost == '' ): ?><span class="noo-attr-style"><?php echo __('FREE', 'noo'); ?></span><?php endif; ?>
                    <span class="entry-date">
                        <?php echo get_the_date('d'); ?>
                        <span class="month">
                            <?php echo get_the_date('F'); ?>
                        </span>
                    </span>
                    <?php the_title( '<h2 class="tribe-events-single-event-title summary entry-title">', '</h2>' ); ?>

                    <div class="tribe-events-schedule updated published tribe-clearfix">
                        <?php echo tribe_events_event_schedule_details( $event_id, '<span class="sh-time-event"><i class="fa fa-clock-o"></i>', '</span>' ); ?>
                        <span class="sh-address"><i class="fa  fa-map-marker"></i><?php echo tribe_get_venue().','.tribe_get_full_address(get_the_ID())  ; ?></span>
                        <?php if ( tribe_get_cost() ) : ?>
                            <div class="pull-right noo-tribe-money">
                                <i class="fa fa-money"></i>
                                <span class="tribe-events-cost"><?php echo tribe_get_cost( null, true ) ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <!-- Event featured image, but exclude link -->
                    <?php echo tribe_event_featured_image( $event_id, 'full', false ); ?>

                    <!-- Event content -->
                    <?php do_action( 'tribe_events_single_event_before_the_content' ) ?>
                    <div class="tribe-events-single-event-description tribe-events-content entry-content description">
                        <?php the_content(); ?>
                    </div>
                    <div class="content-social">
                        <?php echo noo_social_share(get_the_ID(),false); ?>
                    </div>
                    <!-- .tribe-events-single-event-description -->
                    <?php do_action( 'tribe_events_single_event_after_the_content' ) ?>


                </div>
                <?php
                $gallery = noo_get_post_meta(get_the_ID(), '_noo_wp_event_gallery');
                ?>
                <div class="noo-tabs-wrap">

                    <ul class="noo-tabs-header">
                        <?php if( isset($gallery) && !empty($gallery) ): ?>
                            <li>
                                <span class="noo-tabs-title" data-option-value="event-gallery"><?php echo __('Gallery', 'noo'); ?></span>
                            </li>
                        <?php endif; ?>
                        <li>
                            <span class="noo-tabs-title" data-option-value="event-comment-list"><?php echo __('Comments', 'noo'); ?></span>
                        </li>
                    </ul>

                    <div class="noo-tabs-content">
                        <?php   if( isset($gallery) && !empty($gallery) ){ ?>
                            <div id="event-gallery" class="noo-tab-content">
                                <div class="pr-gallery">
                                    <ul class="event-single-gallery">
                                        <?php
                                            $gallery_args = explode(',',$gallery);
                                            foreach( $gallery_args as $id ):
                                                $href = wp_get_attachment_url(esc_attr($id));
                                                $arr_img = get_post_meta(esc_attr($id), '_wp_attachment_image_alt', true);
                                                ?>
                                                <li>
                                                    <a class="noo-tngallery" data-lightbox-gallery="gallery1" href="<?php echo esc_url($href); ?>" title="<?php echo esc_attr($arr_img); ?>">
                                                        <?php echo wp_get_attachment_image(esc_attr($id),'noo-thumbnail-square'); ?>
                                                    </a>
                                                </li>
                                            <?php
                                            endforeach;

                                        ?>
                                    </ul>
                                </div>
                            </div>
                        <?php } ?>
                        <div id="event-comment-list" class="noo-tab-content">
                            <?php if ( get_post_type() == Tribe__Events__Main::POSTTYPE && tribe_get_option( 'showComments', false ) ) comments_template() ?>
                        </div>
                    </div>

                </div>
                <script>
                    jQuery(function () {
                        jQuery('.noo-tngallery').nivoLightbox({
                            effect: 'slideUp'
                        });

                        jQuery('.noo-tabs-content .noo-tab-content:first').show();
                        jQuery('.noo-tabs-header .noo-tabs-title:first').addClass('tab-active');

                        jQuery('span.noo-tabs-title').click(function(){

                            jQuery(this).parent().parent().find('span').removeClass('tab-active');
                            jQuery(this).addClass('tab-active');
                            var $id = jQuery(this).attr('data-option-value');
                            jQuery(this).parent().parent().parent().find('.noo-tab-content').fadeOut(0);
                            jQuery('#'+$id).fadeIn(0);

                        }) ;
                    })
                </script>

                <!-- Event footer -->
                <div id="tribe-events-footer">
                    <!-- Navigation -->
                    <!-- Navigation -->
                    <h3 class="tribe-events-visuallyhidden"><?php _e( 'Event Navigation', 'tribe-events-calendar' ) ?></h3>
                    <ul class="tribe-events-sub-nav">
                        <li class="tribe-events-nav-previous"><?php tribe_the_prev_event_link( '<span>&laquo;</span> %title%' ) ?></li>
                        <li class="tribe-events-nav-next"><?php tribe_the_next_event_link( '%title% <span>&raquo;</span>' ) ?></li>
                    </ul>
                    <!-- .tribe-events-sub-nav -->
                </div>
                <!-- #tribe-events-footer -->
            </div>
            <div class="col-md-3">
                <!-- Event meta -->
                <?php do_action( 'tribe_events_single_event_before_the_meta' ) ?>
                <?php
                /**
                 * The tribe_events_single_event_meta() function has been deprecated and has been
                 * left in place only to help customers with existing meta factory customizations
                 * to transition: if you are one of those users, please review the new meta templates
                 * and make the switch!
                 */
                if ( ! apply_filters( 'tribe_events_single_event_meta_legacy_mode', false ) ) {
                    tribe_get_template_part( 'modules/meta' );
                } else {
                    echo tribe_events_single_event_meta();
                }
                ?>
                <?php  do_action( 'tribe_events_single_event_after_the_meta' ) ?>
            </div>

		</div> <!-- #post-x -->
	<?php endwhile; ?>


</div><!-- #tribe-events-content -->
