<?php
/**
 * Photo View Single Event
 * This file contains one event in the photo view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/photo/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
} ?>

<?php

global $post;
$noo_cost = tribe_get_event_meta( get_the_ID(), '_EventCost', true );

?>

<div class="tribe-events-photo-event-wrap">
    <!-- Event Title -->
    <?php do_action( 'tribe_events_before_the_event_title' ); ?>
    <h2 class="tribe-events-list-event-title entry-title summary">
        <a class="url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title() ?>" rel="bookmark">
            <?php the_title(); ?>
        </a>
    </h2>
    <?php do_action( 'tribe_events_after_the_event_title' ); ?>
    <div class="noo-tribe-events-image">
        <?php if( isset($noo_cost) && $noo_cost == '' ): ?><span class="noo-attr-style"><?php echo __('FREE', 'noo'); ?></span><?php endif; ?>
        <?php echo tribe_event_featured_image( null, 'noo-thumbnail-square' ); ?>
        <!-- Event Meta -->
        <?php do_action( 'tribe_events_before_the_meta' ); ?>
        <div class="tribe-events-event-meta">
            <div class="updated published time-details">
                <?php if ( ! empty( $post->distance ) ) : ?>
                    <strong>[<?php echo tribe_get_distance_with_unit( $post->distance ); ?>]</strong>
                <?php endif; ?>
                <?php echo tribe_events_event_schedule_details(); ?>
            </div>
        </div><!-- .tribe-events-event-meta -->
        <?php do_action( 'tribe_events_after_the_meta' ); ?>
    </div>

	<div class="tribe-events-event-details tribe-clearfix">
		<!-- Event Content -->
		<?php do_action( 'tribe_events_before_the_content' ); ?>
		<div class="tribe-events-list-photo-description tribe-events-content entry-summary description">
			<?php echo tribe_events_get_the_excerpt() ?>
		</div>
		<?php do_action( 'tribe_events_after_the_content' ) ?>

        <a href="<?php echo esc_url( tribe_get_event_link() ); ?>" class="tribe-events-read-more" rel="bookmark"><?php _e( 'READ MORE', 'tribe-events-calendar' ) ?></a>

	</div><!-- /.tribe-events-event-details -->

</div><!-- /.tribe-events-photo-event-wrap -->
