<?php
/**
 * Day View Single Event
 * This file contains one event in the day view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/day/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
$venue_details = array();

if ( $venue_name = tribe_get_meta( 'tribe_event_venue_name' ) ) {
    $venue_details['name'] = $venue_name;
}

if ( $venue_address = tribe_get_meta( 'tribe_event_venue_address' ) ) {
    $venue_details['address'] = $venue_address;
}
$venue_details = tribe_get_venue_details();

// Venue microformats
$has_venue = ( $venue_details ) ? ' vcard' : '';
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';
$noo_cost = tribe_get_event_meta( get_the_ID(), '_EventCost', true );
?>

<!-- Event Title -->
<?php do_action( 'tribe_events_before_the_event_title' ) ?>
<h2 class="tribe-events-list-event-title entry-title summary">
    <a class="url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title() ?>" rel="bookmark">
        <?php the_title() ?>
    </a>
</h2>
<?php do_action( 'tribe_events_after_the_event_title' ) ?>
<div class="noo-tribe-events-image">
    <?php if( isset($noo_cost) && $noo_cost == '' ): ?><span class="noo-attr-style"><?php echo __('FREE', 'noo'); ?></span><?php endif; ?>
    <!-- Event Meta -->
    <?php do_action( 'tribe_events_before_the_meta' ) ?>
    <div class="tribe-events-event-meta vcard">
        <div class="author <?php echo $has_venue_address; ?>">

            <!-- Schedule & Recurrence Details -->
            <div class="updated published time-details">
                <i class="fa fa-calendar"></i><?php echo tribe_events_event_schedule_details() ?>
            </div>

            <?php if ( $venue_details ) : ?>
                <!-- Venue Display Info -->
                <div class="tribe-events-venue-details">
                    <i class="fa  fa-map-marker"></i><?php echo implode( ', ', $venue_details ); ?>
                </div> <!-- .tribe-events-venue-details -->
            <?php endif; ?>

        </div>
    </div><!-- .tribe-events-event-meta -->
    <?php do_action( 'tribe_events_after_the_meta' ) ?>

    <!-- Event Image -->
    <?php echo tribe_event_featured_image( null, 'full' ) ?>
</div>

<!-- Event Content -->
<?php do_action( 'tribe_events_before_the_content' ) ?>
<div class="tribe-events-list-event-description tribe-events-content description entry-summary">
    <?php the_excerpt() ?>
    <a href="<?php echo esc_url( tribe_get_event_link() ); ?>" class="tribe-events-read-more" rel="bookmark"><?php _e( 'READ MORE', 'tribe-events-calendar' ) ?></a>
</div><!-- .tribe-events-list-event-description -->
<?php do_action( 'tribe_events_after_the_content' ) ?>
