<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php if ( !is_singular() ) : ?>
    <div class="content-social">
        <?php echo noo_social_share(get_the_ID(),false); ?>
    </div>
    <?php endif?>
    <header class="content-header">
        <?php if ( is_singular() ) : ?>
            <h1 class="content-title">
                <?php the_title(); ?>
            </h1>
            <?php
            $categories = get_the_category();
            $categories_html = '';
            if($categories) :?>
                <div class="noo-category">
                    <?php
                    foreach ($categories as $category) {
                        $categories_html.= '<a' . ' href="' . get_category_link($category->term_id) . '"' . ' title="' . esc_attr(sprintf(__("View all posts in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>';
                    }
                    echo ($categories_html);
                    ?>

                </div>
            <?php endif; ?>
            <?php noo_content_meta(); ?>
        <?php else : ?>
            <?php
            $categories = get_the_category();
            $categories_html = '';
            if($categories) :?>
                <div class="noo-category">
                    <?php
                    foreach ($categories as $category) {
                        $categories_html.= '<a' . ' href="' . get_category_link($category->term_id) . '"' . ' title="' . esc_attr(sprintf(__("View all posts in: &ldquo;%s&rdquo;", 'noo') , $category->name)) . '">' . ' ' . $category->name . '</a>';
                    }
                    echo ($categories_html);
                    ?>

                </div>
           <?php endif; ?>
            <h2 class="content-title">
                <a href="<?php the_permalink(); ?>" title="<?php echo esc_attr( sprintf( __( 'Permanent link to: "%s"','noo' ), the_title_attribute( 'echo=0' ) ) ); ?>"><?php the_title(); ?></a>
            </h2>
        <?php endif; ?>

    </header>
	<?php if( has_featured_content()) : ?>
	<div class="content-featured">
		<?php noo_featured_default(); ?>
        <?php if ( !is_singular() ) : ?>
            <?php if(noo_get_option('noo_blog_post_author_bio', true)):?>
                <div class="author-avatar">
                    <?php echo get_avatar( get_the_author_meta( 'user_email' ),70); ?>
                </div>
            <?php endif;?>
        <?php endif;?>
	</div>
	<?php endif; ?>
	
	<div class="content-wrap">
		<?php if ( is_singular() ) : ?>
			<div class="content">
				
				<?php the_content(); ?>
				<?php wp_link_pages(); ?>
                <?php if(has_tag()) : ?>
                    <div class="entry-tags">
                        <?php the_tags(sprintf('<span>%s</span>',__('Tags ','noo')),'')?>
                    </div>
                <?php endif;?>
                <div class="content-social">
                    <?php echo noo_social_share(get_the_ID(),false); ?>
                </div>
			</div>
		<?php else : ?>
            <?php noo_content_meta(); ?>
			<div class="content-excerpt">
				<?php if(get_the_excerpt()):?>
					<?php the_excerpt(); ?>
					<?php noo_readmore_link(); ?>
				<?php endif;?>
			</div>
		<?php endif; ?>

		
	</div>
	<?php noo_get_layout('post', 'footer'); ?>
</article> <!-- /#post- -->