<?php
	$quote = '';
	$quote = noo_get_post_meta(get_the_id() , '_noo_wp_post_quote', '');
	if($quote == '') {
		$quote = get_the_title( get_the_id() );
	}
	$cite = noo_get_post_meta(get_the_id() , '_noo_wp_post_quote_citation', '');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<div class="content-wrap">
		<header class="content-header">
			<?php if (is_singular()): ?>
				<h1 class="content-title content-quote">
					<?php echo esc_html($quote); ?>
				</h1>
				<cite class="content-sub-title content-cite"><?php echo esc_html($cite); ?></cite>
				<?php noo_content_meta(); ?>
				<?php echo noo_social_count(); ?>
			<?php else : ?>
				<h2 class="content-title content-quote">
					<a href="<?php the_permalink(); ?>" title="<?php echo esc_attr(sprintf(__('Permanent link to: "%s"', 'noo') , the_title_attribute('echo=0'))); ?>">
						<?php echo esc_html($quote); ?>
					</a>
				</h2>
				<cite class="content-sub-title content-cite"><i class="fa fa-quote-right"></i> <?php echo esc_html($cite); ?></cite>
			<?php endif; ?>
		</header>
		<?php if (is_singular()): ?>
			<div class="content">
				<?php if (has_featured_content()): ?>
				<div class="content-featured">
					<?php noo_featured_quote(); ?>
				</div>
				<?php endif; ?>
				<?php if( is_locked_post( get_the_ID() ) ) : ?>
					<?php echo locked_post_content( get_the_ID() ); ?>
				<?php else: ?>
					<?php the_content(); ?>
				<?php endif;?>
				<?php wp_link_pages(); ?>
				<?php if((noo_get_option('noo_blog_post_show_post_tag', true)) && has_tag()):?>
					<div class="entry-tags">
					<?php the_tags(sprintf('<span>%s</span>',__('Tags ','noo')),'')?>
					</div>
				<?php endif;?>
			</div>
		<?php else: ?>
			<!-- Don't use excerpt in Quote post -->
			<!-- <div class="content-excerpt">
				<?php // the_excerpt(); ?>
			</div> -->
		<?php endif; ?>
	</div>
	<?php if( has_featured_content()) : ?>
		<?php if(!is_singular()): ?>
			<div class="content-featured col-md-6">
				<?php noo_featured_default(); ?>
				<?php if(esc_html(noo_get_post_meta(get_the_ID(),'noo_reader_count_rating',0) )) {?>
					<div class="noo_rating_point">
						<?php echo esc_html(noo_get_post_meta(get_the_ID(),'noo_reader_count_rating',0) );?>
					</div>
				<?php } ?>
			</div>				
		<?php endif; ?>
	<?php endif; ?>
	<?php noo_get_layout('post', 'footer'); ?>
</article> <!-- /#post- -->