<?php

if( !function_exists('noo_shortcode_team') ){
    function noo_shortcode_team($attrs){
        extract(shortcode_atts(array(
            'title'            =>  '',
            'description'      =>  '',
            'categories'       =>  '',
            'limit'            =>  4,
            'orderby'          =>  'date'
        ),$attrs));
        ob_start();
        $order = 'DESC';
        switch ($orderby) {
            case 'latest':
                $orderby = 'date';
                break;

            case 'oldest':
                $orderby = 'date';
                $order   = 'ASC';
                break;

            case 'alphabet':
                $orderby = 'title';
                $order   = 'ASC';
                break;

            case 'ralphabet':
                $orderby = 'title';
                break;

            default:
                $orderby = 'date';
                break;
        }
        ?>
        <div class="noo_team">
            <?php if( isset($title) && !empty($title) ): ?>

                <h2 class="noo-team-title">
                    <?php echo esc_html($title); ?>
                </h2>
            <?php endif; ?>
            <?php if( isset($description) && !empty($description)): ?>
                <p class="noo-team-ds"><?php echo esc_html($description) ?></p>
            <?php endif; ?>
            <!--Noo team contents-->
            <div class="row noo-team-contents">
                <?php
                $args = array(
                    'post_type'         =>  'team_member',
                    'posts_per_page'    =>  $limit,
                    'orderby'           =>  $orderby,
                    'order'             =>  $order,
                );
                if( $categories != 'all' ){
                    $args['tax_query'][]  = array(
                        'taxonomy'  =>  'team_category',
                        'field'     =>  'id',
                        'terms'     =>   array($categories)
                    );
                }
                $query = new WP_Query($args);
                if( $query->have_posts() ):
                    while( $query->have_posts() ):
                        $query->the_post();
                        $image_id    = get_post_meta(get_the_ID(),'_noo_wp_team_image', true);
                        $name        = get_post_meta(get_the_ID(),'_noo_wp_team_name', true);
                        $position    = get_post_meta(get_the_ID(),'_noo_wp_team_position', true);
                        $description = get_post_meta(get_the_ID(),'_noo_wp_team_description', true);

                        $facebook    = get_post_meta(get_the_ID(),'_noo_wp_team_facebook', true);
                        $twitter     = get_post_meta(get_the_ID(),'_noo_wp_team_twitter', true);
                        $google      = get_post_meta(get_the_ID(),'_noo_wp_team_google', true);
                        $linkedin    = get_post_meta(get_the_ID(),'_noo_wp_team_linkedin', true);

                        $flickr      = get_post_meta(get_the_ID(),'_noo_wp_team_flickr', true);
                        $pinterest   = get_post_meta(get_the_ID(),'_noo_wp_team_pinterest', true);
                        $instagram   = get_post_meta(get_the_ID(),'_noo_wp_team_instagram', true);
                        $tumblr      = get_post_meta(get_the_ID(),'_noo_wp_team_tumblr', true);
                        ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="noo_team_item">

                                <!--Team thumbnail-->
                                <div class="team_thumbnail">
                                    <?php echo wp_get_attachment_image(esc_attr($image_id),'noo-thumbnail-square'); ?>
                                    <div class="team-info">
                                        <h4 class="team_name"><?php echo esc_html($name); ?></h4>
                                        <span class="team_position"><?php echo esc_html($position); ?></span>
                                    </div>
                                </div>
                                <!--End Team thumbnail-->

                                <!--Team Detail-->
                                <div class="team-detail">
                                    <div class="team-detail-position">
                                        <p class="ds"><?php echo esc_html($description); ?></p>
                                        <div class="team_socials">
                                            <?php if( isset($facebook) && $facebook !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on facebook', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($facebook) ?>" class="fa fa-facebook"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($twitter) && $twitter !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on twitter', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($twitter) ?>" class="fa fa-twitter"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($google) && $google !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on google', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($google) ?>" class="fa fa-google-plus"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($linkedin) && $linkedin !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on linkedin', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($linkedin) ?>" class="fa fa-linkedin"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($flickr) && $flickr !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on flickr', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($flickr) ?>" class="fa fa-flickr"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($pinterest) && $pinterest !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on pinterest', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($pinterest) ?>" class="fa fa-pinterest"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($instagram) && $instagram !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on instagram', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($instagram) ?>" class="fa fa-instagram"></a>
                                                </span>
                                            <?php endif; ?>
                                            <?php if( isset($tumblr) && $tumblr !='' ): ?>
                                                <span class="team_social">
                                                    <span class="social-name"><?php echo __('Follow on tumblr', 'noo') ; ?></span>
                                                    <a href="<?php echo esc_url($tumblr) ?>" class="fa fa-tumblr"></a>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <!--End Team Detail-->

                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </div>
            <!--End team contents-->
        </div>
        <?php
        $team = ob_get_contents();
        ob_end_clean();
        return $team;
    }
    add_shortcode('noo_team','noo_shortcode_team');
}

?>