<?php

    if(!function_exists('noo_shortcode_featured_albums')){
    function noo_shortcode_featured_albums($atts){
        extract(shortcode_atts(array(
            'title'         =>  '',
            'icon'          =>  'fa fa-calendar',
            'description'   =>  '',
            'orderby'       =>  '',
            'limit'         =>  ''
        ),$atts));
        ob_start();
        wp_enqueue_script('noo-carousel');
    ?>
        <div class="wrap">
            <div class="container">
                <div class="noo-grid-header-events header-featured-albums">
                    <span class="icon">
                        <i class="<?php echo esc_attr($icon) ?>"></i>
                    </span>
                    <?php if( isset($title) && !empty($title) ): ?>

                        <h2 class="sh-event-title">
                            <?php echo esc_html($title); ?>
                        </h2>
                    <?php endif; ?>
                    <?php if( isset($description) && !empty($description)): ?>
                        <p class="sh-ds"><?php echo esc_html($description) ?></p>
                    <?php endif; ?>
                </div>
            </div>


            <ul class="clearfix noo-featured-albums">
                <?php
                $order = 'DESC';
                switch ($orderby) {
                    case 'latest':
                        $orderby = 'date';
                        break;

                    case 'oldest':
                        $orderby = 'date';
                        $order = 'ASC';
                        break;

                    case 'alphabet':
                        $orderby = 'title';
                        $order = 'ASC';
                        break;

                    case 'ralphabet':
                        $orderby = 'title';
                        break;

                    default:
                        $orderby = 'date';
                        break;
                }
                $args = array(
                    'post_type'           => 'noo_album',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $limit,
                    'orderby'             => $orderby,
                    'order'               => $order
                );
                $query = new WP_Query($args);
                if( $query->have_posts() ):
                    while( $query->have_posts() ):
                        $query->the_post();
                        ?>

                        <li>
                            <div class="sh-featured-albumns-item">
                                <?php
                                if ( has_post_thumbnail() ) {
                                    echo get_the_post_thumbnail( get_the_ID(), 'noo-loop-album' );
                                }
                                ?>
                                <div class="sh-top">
                                    <h3 class="product_title"><a href="<?php the_permalink()?>"><?php the_title(); ?></a></h3>
                                </div>
                                <div class="sh-bottom">
                                    <div class="shop-info">
                                        <h3 class="product_title"><a href="<?php the_permalink()?>"><?php the_title(); ?></a></h3>
                                        <div class="product-category"><?php echo get_the_term_list(get_the_ID(),'album_genre')?></div>
                                    </div>
                                    <div class="shop-loop-actions">
                                        <a class="button" href="<?php the_permalink(); ?>"><i class="fa fa-link"></i> <?php _e('Detail','noo') ; ?></a>
                                        <a href="#" data-songs='<?php echo esc_attr(Noo_Album::songs_to_playlist_data(get_the_ID()))?>' class="add-to-playlist-btn button"><i class="fa fa-plus"></i> <?php _e('Add to Playlist', 'noo') ; ?></a>
                                    </div>
                                </div>
                            </div>
                        </li>

                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
                ?>
            </ul>
        </div>
        <script>
            jQuery(document).ready(function(){
                jQuery('.noo-featured-albums').owlCarousel({
                    items : 5,
                    itemsCustom : false,
                    itemsDesktop : [1320, 4],
                    itemsDesktopSmall : [1200, 3],
                    itemsTablet : [768, 2],
                    itemsTabletSmall : false,
                    itemsMobile : [479, 1],
                    slideSpeed:500,
                    paginationSpeed:800,
                    rewindSpeed:1000,
                    autoHeight: false,
                    addClassActive: true,
                    autoPlay: false,
                    loop:true,
                    pagination: true
                });
            });
        </script>
    <?php
        $featured = ob_get_contents();
        ob_end_clean();
        return $featured;
    }
    add_shortcode('featured_albums','noo_shortcode_featured_albums');
   }



?>