<?php
/**
 * NOO Visual Composer Add-ons
 *
 * Customize Visual Composer to suite NOO Framework
 *
 * @package    NOO Framework
 * @subpackage NOO Visual Composer Add-ons
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */
//
// Variables.
//
$category_name                  = __( 'WeMusic', 'noo' );

$param_content_name             = 'content';
$param_content_heading          = __( 'Text', 'noo' );
$param_content_description      = __( 'Enter your text.', 'noo' );
$param_content_type             = 'textarea_html';
$param_content_holder           = 'div';
$param_content_value            = '';

$param_visibility_name          = 'visibility';
$param_visibility_heading       = __( 'Visibility', 'noo' );
$param_visibility_description   = '';
$param_visibility_type          = 'dropdown';
$param_visibility_holder        = 'div';
$param_visibility_value         = array(
    __( 'All Devices', 'noo' )    => "all",
    __( 'Hidden Phone', 'noo' )   => "hidden-phone",
    __( 'Hidden Tablet', 'noo' )  => "hidden-tablet",
    __( 'Hidden PC', 'noo' )      => "hidden-pc",
    __( 'Visible Phone', 'noo' )  => "visible-phone",
    __( 'Visible Tablet', 'noo' ) => "visible-tablet",
    __( 'Visible PC', 'noo' )     => "visible-pc" );

$param_class_name                = 'class';
$param_class_heading             = __( 'Class', 'noo' );
$param_class_description         = __( '(Optional) Enter a unique class name.', 'noo' );
$param_class_type                = 'textfield';
$param_class_holder              = 'div';

$param_custom_style_name         = 'custom_style';
$param_custom_style_heading      = __( 'Custom Style', 'noo' );
$param_custom_style_description  = __( '(Optional) Enter inline CSS.', 'noo' );
$param_custom_style_type         = 'textfield';
$param_custom_style_holder       = 'div';

$param_holder                    = 'div';


// custom [row]
vc_add_param('vc_row', array(
        "type"        =>  "dropdown",
        "class"       =>  "hide_in_vc_editor",
        "admin_label" =>  true,
        "heading"     =>  "Row Type",
        "param_name"  =>  "style_width",
        "value"       => array(
            "Full Width" => "full_width",
            "Boxed"      => "boxed"
        )
    )
);
vc_add_param('vc_row', array(
        "type"        =>  "dropdown",
        "class"       =>  "hide_in_vc_editor",
        "admin_label" => true,
        "heading"     => "Background Parallax",
        "param_name"  => "background_parallax",
        "value" => array(
            "No"      => "none",
            "Yes"     => "yes"
        )
    )
);
vc_add_param('vc_row', array(
        "type"          =>  "colorpicker",
        "class"         =>  "hide_in_vc_editor",
        "admin_label"   => true,
        "heading"       => "Overlay Parallax",
        "param_name"    => "overlay_parallax",
        "dependency"    => Array('element' => "background_parallax", 'value' => array('yes'))
    )
);
vc_remove_param( "vc_row", "parallax" );
vc_remove_param( "vc_row", "parallax_image" );

// custom button
$colors_arr = array(
    __( 'Grey', 'js_composer' ) => 'wpb_button',
    __( 'Blue', 'js_composer' ) => 'btn-primary',
    __( 'Turquoise', 'js_composer' ) => 'btn-info',
    __( 'Green', 'js_composer' ) => 'btn-success',
    __( 'Orange', 'js_composer' ) => 'btn-warning',
    __( 'Red', 'js_composer' ) => 'btn-danger',
    __( 'Black', 'js_composer' ) => "btn-inverse",
    __( 'Primary', 'js_composer' ) => "btn-noo-primary"
);

$colors_arr2 = array(
    'Blue'          => 'blue', // Why __( 'Blue', 'js_composer' ) doesn't work?
    'Turquoise'     => 'turquoise',
    'Pink'          => 'pink',
    'Violet'        => 'violet',
    'Peacoc'        => 'peacoc',
    'Chino'         => 'chino',
    'Mulled Wine'   => 'mulled_wine',
    'Vista Blue'    => 'vista_blue',
    'Black'         => 'black',
    'Grey'          => 'grey',
    'Orange'        => 'orange',
    'Sky'           => 'sky',
    'Green'         => 'green',
    'Juicy pink'    => 'juicy_pink',
    'Sandy brown'   => 'sandy_brown',
    'Purple'        => 'purple',
    'White'         => 'white',
    'Primary'       => 'noo_primary'
);
vc_remove_param( "vc_button", "color" );
vc_add_param('vc_button', array(
        'type'          => 'dropdown',
        'heading'       => __( 'Color', 'js_composer' ),
        'param_name'    => 'color',
        'value'         => $colors_arr,
        'description'   => __( 'Button color.', 'js_composer' ),
        'param_holder_class' => 'vc_colored-dropdown'
    )
);
vc_remove_param( "vc_button2", "color" );
vc_add_param('vc_button2', array(
        'type'          => 'dropdown',
        'heading'       => __( 'Color', 'js_composer' ),
        'param_name'    => 'color',
        'value'         => $colors_arr2,
        'description'   => __( 'Button color.', 'js_composer' ),
        'param_holder_class' => 'vc_colored-dropdown'
    )
);



// [slider] Responsive Slider
// ============================
vc_map(
    array(
        'base'              => 'slider',
        'name'              => __( 'Responsive Slider', 'noo' ),
        'weight'            => 570,
        'class'             => 'noo-vc-element noo-vc-element-slider',
        'icon'              => 'noo-vc-icon-slider',
        'category'          => $category_name,
        'description'       => '',
        'as_parent'         => array( 'only' => 'slide' ),
        'content_element'   => true,
        'js_view'           => 'VcColumnView',
        'params'            => array(
            array(
                'param_name'     => 'animation',
                'heading'        => __( 'Animation', 'noo' ),
                'description'    => '',
                'type'           => 'dropdown',
                'value'          => array(
                    __( 'Slide', 'noo' ) => 'slide',
                    __( 'Fade', 'noo' ) => 'fade' ) ),

            array(
                'param_name'     => 'visible_items',
                'heading'        => __( 'Columns Number', 'noo' ),
                'type'           => 'dropdown',
                'value'          => array(
                    __( '1', 'noo' ) => '1',
                    __( '2', 'noo' ) => '2',
                    __( '3', 'noo' ) => '3',
                    __( '4', 'noo' ) => '4' )
            ),
            array(
                'param_name'     => 'slider_time',
                'heading'        => __( 'Slide Time (ms)', 'noo' ),
                'description'    => '',
                'type'           => 'ui_slider',
                'value'          => '3000',
                'data_min'       => '500',
                'data_max'       => '8000',
                'data_step'      => '100' ),
            array(
                'param_name'     => 'slider_speed',
                'heading'        => __( 'Slide Speed (ms)', 'noo' ),
                'description'    => '',
                'type'           => 'ui_slider',
                'value'          => '600',
                'data_min'       => '100',
                'data_max'       => '3000',
                'data_step'      => '100' ),
            array(
                'param_name'     => 'auto_play',
                'heading'        => __( 'Auto Play Slider', 'noo' ),
                'description'    => '',
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'pause_on_hover',
                'heading'        => __( 'Pause on Hover', 'noo' ),
                'description'    => __( 'If auto play, pause slider when mouse over it?', 'noo' ),
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'random',
                'heading'        => __( 'Random Slider', 'noo' ),
                'description'    => __( 'Random Choose Slide to Start', 'noo' ),
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'indicator',
                'heading'        => __( 'Show Slide Indicator', 'noo' ),
                'description'    => '',
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'indicator_position',
                'heading'        => __( 'Indicator Position', 'noo' ),
                'description'    => '',
                'type'           => 'dropdown',
                'value'          => array(
                    __( 'Top', 'noo' )    => 'top',
                    __( 'Bottom', 'noo' ) => 'bottom' ) ),
            array(
                'param_name'     => 'prev_next_control',
                'heading'        => __( 'Show Previous/Next Navigation', 'noo' ),
                'description'    => '',
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'timer',
                'heading'        => __( 'Show Timer', 'noo' ),
                'description'    => '',
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => 'swipe',
                'heading'        => __( 'Enable Swipe on Mobile', 'noo' ),
                'description'    => '',
                'type'           => 'checkbox',
                'value'          => array( '' => 'true' ) ),
            array(
                'param_name'     => $param_visibility_name,
                'heading'        => $param_visibility_heading,
                'description'    => $param_visibility_description,
                'type'           => $param_visibility_type,
                'value'          => $param_visibility_value ),
            array(
                'param_name'     => $param_class_name,
                'heading'        => $param_class_heading,
                'description'    => $param_class_description,
                'type'           => $param_class_type,
                'holder'         => $param_class_holder ),
            array(
                'param_name'     => $param_custom_style_name,
                'heading'        => $param_custom_style_heading,
                'description'    => $param_custom_style_description,
                'type'           => $param_custom_style_type
            ) ) ) );

// [slide] Responsive Slider Item
// ============================
vc_map(
    array(
        'base'            => 'slide',
        'name'            => __( 'Slide', 'noo' ),
        'weight'          => 575,
        'class'           => 'noo-vc-element noo-vc-element-slide',
        'icon'            => 'noo-vc-icon-slide',
        'category'        => $category_name,
        'description'     => '',
        'as_child'        => array( 'only' => 'slider' ),
        'content_element' => true,
        'params'          => array(
            array(
                'param_name'    => 'type',
                'heading'       => __( 'Type', 'noo' ),
                'description'   => __('Choose the type of this slide: Image, Video or HTML Content', 'noo' ),
                'type'          => 'dropdown',
                'holder'        => $param_holder,
                'value'         => array(
                    __( 'Image', 'noo' ) => 'image',
                    __( 'HTML Content', 'noo' ) => 'content' ) ),
            array(
                'param_name'    => 'image',
                'heading'       => __( 'Image', 'noo' ),
                'description'   => '',
                'type'          => 'attach_image',
                'admin_label'   => true,
                'holder'        => $param_holder,
                'dependency'    => array( 'element' => 'type', 'value' => array( 'image' ) ) ),
            array(
                'param_name'    => 'caption',
                'heading'       => __( 'Image Caption', 'noo' ),
                'description'   => '',
                'type'          => 'textarea',
                'holder'        => $param_holder,
                'dependency'    => array( 'element' => 'type', 'value' => array( 'image' ) ) ),

            array(
                'param_name'    => $param_content_name,
                'heading'       => __( 'HTML Content (only for HTML Content slide)', 'noo' ),
                'description'   => $param_content_description,
                'type'          => $param_content_type,
                'holder'        => $param_content_holder,
                'value'         => $param_content_value,
                'dependency'    => array( 'element' => 'type', 'value' => array( 'content' ) ) ),
            array(
                'param_name'    => $param_class_name,
                'heading'       => $param_class_heading,
                'description'   => $param_class_description,
                'type'          => $param_class_type,
                'holder'        => $param_class_holder ),
            array(
                'param_name'    => $param_custom_style_name,
                'heading'       => $param_custom_style_heading,
                'description'   => $param_custom_style_description,
                'type'          => $param_custom_style_type,
                'holder'        => $param_custom_style_holder ) ) ) );
vc_map(
    array(
        'base'          => 'noo_blog_masonry',
        'name'          => __( 'Noo Blog Masonry', 'noo' ),
        'weight'        => 809,
        'class'         => 'noo-vc-element noo-vc-element-noo_classic_list_blog',
        'icon'          => 'noo-vc-icon-noo_recent_news',
        'category'      => $category_name,
        'description'   => '',
        'params'        => array(
            array(
                'param_name'    => 'categories',
                'heading'       => __( 'Categories', 'noo' ),
                'description'   => __('Select categories.', 'noo' ),
                'type'          => 'post_categories',
                'admin_label'   => true,
                'holder'        => $param_holder ),
            array(
                'param_name'    => 'title',
                'heading'       => __( 'Title', 'noo' ),
                'description'   => __('Enter text which will be used as element title. Leave blank if no title is needed.', 'noo' ),
                'type'          => 'textfield',
                'admin_label'   => true,
                'holder'        => $param_holder ),
            array(
                'param_name'    => 'orderby',
                'heading'       => __( 'Order By', 'noo' ),
                'description'   => '',
                'type'          => 'dropdown',
                'holder'        => $param_holder,
                'value'         => array(
                    __( 'Recent First', 'noo' )             => 'latest',
                    __( 'Older First', 'noo' )              => 'oldest',
                    __( 'Title Alphabet', 'noo' )           => 'alphabet',
                    __( 'Title Reversed Alphabet', 'noo' )  => 'ralphabet' ) ),
            array(
                'param_name'    => 'posts_per_page',
                'heading'       => __( 'Posts per page', 'noo' ),
                'type'          => 'textfield',
                'admin_label'   => true,
                'value'         => '3',
                'holder'        => $param_holder ),
            array(
                'param_name'    => 'columns',
                'heading'       => __( 'Columns', 'noo' ),
                'description'   => '',
                'type'          => 'dropdown',
                'holder'        => $param_holder,
                'value'         => array(
                    __( '1', 'noo' ) => '1',
                    __( '2', 'noo' ) => '2',
                    __( '3', 'noo' ) => '3',
                    __( '4', 'noo' ) => '4' ) ),
            array(
                'param_name'    => 'excerpt_length',
                'heading'       => __( 'Excerpt Length', 'noo' ),
                'type'          => 'textfield',
                'std'           => 20,
                'admin_label'   => true,
                'holder'        => $param_holder ),
            array(
                'param_name'    => $param_class_name,
                'heading'       => $param_class_heading,
                'description'   => $param_class_description,
                'type'          => $param_class_type,
                'holder'        => $param_class_holder ),
            array(
                'param_name'    => $param_custom_style_name,
                'heading'       => $param_custom_style_heading,
                'description'   => $param_custom_style_description,
                'type'          => $param_custom_style_type,
                'holder'        => $param_custom_style_holder
            )
        )
    )
);

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

    class WPBakeryShortCode_Slider extends WPBakeryShortCodesContainer {
    }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

    class WPBakeryShortCode_Slide extends WPBakeryShortCode {
    }
}


// Noo countdown
vc_map(array(
    'base'        => 'noo_countdown',
    'name'        => __( 'Noo CountDown', 'noo' ),
    'class'       => 'noo-icon-countdown',
    'icon'        => 'noo-icon-countdown',
    'category'    => $category_name,
    'description' => '',
    'params'      => array(
        array(
            'param_name'    => 'date',
            'heading'       => __( 'Choose date', 'noo' ),
            'description'   => '',
            'type'          => 'noo_datepicker',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'button_name',
            'heading'       => __( 'Button Name', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'button_link',
            'heading'       => __( 'Button Link', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'background',
            'heading'       => __( 'Background style', 'noo' ),
            'description'   => '',
            'type'          => 'dropdown',
            'admin_label'   => true,
            'holder'        => $param_holder,
            'group'         => __( 'Design options', 'noo' ),
            'value'         => array(
                    "Parallax"             => "parallax",
                    "Slider"               => "slider",
                    "Video Youtube"        => "youtube"
                )
        ),
        array(
            'param_name'    => 'parallax_image',
            'heading'       => __( 'Parallax', 'noo' ),
            'description'   => '',
            'type'          => 'attach_image',
            'admin_label'   => true,
            'holder'        => $param_holder,
            "dependency"    => Array('element' => "background", 'value' => array('parallax')),
            'group'         => __( 'Design options', 'noo' ),
        ),
        array(
            'param_name'    => 'slider_image',
            'heading'       => __( 'Slider', 'noo' ),
            'description'   => '',
            'type'          => 'attach_images',
            'admin_label'   => true,
            'holder'        => $param_holder,
            "dependency"    => Array('element' => "background", 'value' => array('slider')),
            'group'         => __( 'Design options', 'noo' ),
        ),
        array(
            'param_name'    => 'link_youtube',
            'heading'       => __( 'Youtube Link', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder,
            "dependency"    => Array('element' => "background", 'value' => array('youtube')),
            'group'         => __( 'Design options', 'noo' ),
        ),
        array(
            'param_name'    => 'back_youtube',
            'heading'       => __( 'Background Youtube', 'noo' ),
            'description'   => __('Because jquery youtube do  support on mobile so you need upload image for mobile','noo'),
            'type'          => 'attach_images',
            'admin_label'   => true,
            'holder'        => $param_holder,
            "dependency"    => Array('element' => "background", 'value' => array('youtube')),
            'group'         => __( 'Design options', 'noo' ),
        ),
        array(
            'param_name'    => 'overlay_parallax',
            'heading'       => __( 'Overlay', 'noo' ),
            'description'   => '',
            'type'          => 'colorpicker',
            'admin_label'   => true,
            'holder'        => $param_holder,
            "dependency"    => Array('element' => "background", 'value' => array('parallax','slider')),
            'group'         => __( 'Design options', 'noo' ),
        ),
        array(
            'param_name' => 'slider_height',
            'heading' => __('Height Style', 'noo'),
            'description' => '',
            'type' => 'dropdown',
            'holder' => 'div',
            'group'         => __( 'Design options', 'noo' ),
            'value' => array(
                'Full Screen'   => 1,
                'Custom Height' => 2
            )
        ),
        array(
            'param_name' => 'height_custom',
            'heading' => __('Import Height', 'noo'),
            'description' => 'unit px',
            'type' => 'textfield',
            'holder' => 'div',
            'value' => '650',
            'dependency' => array(
                'element' => 'slider_height',
                'value' => array('2')
            ),
            'group'         => __( 'Design options', 'noo' ),
        ),
    )
));


// noo event

vc_map(array(
    'base'        => 'noo_events_list',
    'name'        => __( 'Noo Events List', 'noo' ),
    'class'       => 'noo-icon-events',
    'icon'        => 'noo-icon-events',
    'category'    => $category_name,
    'description' => '',
    'params'      => array(
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'cat',
            'heading'       => __('Categories Events', 'noo'),
            'description'   => '',
            'type'          => 'categories_events',
            'value'         => '',
            'horder'        => 'div',
            'admin_label'   => true
        ),
        array(
            'param_name'  => 'orderby',
            'heading'     => __( 'Order By', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       => array(
                __( 'Recent First', 'noo' )             => 'latest',
                __( 'Older First', 'noo' )              => 'oldest',
                __( 'Title Alphabet', 'noo' )           => 'alphabet',
                __( 'Title Reversed Alphabet', 'noo' )  => 'ralphabet' )
        ),
        array(
            'param_name'    => 'limit',
            'heading'       => __( 'Limited', 'noo' ),
            'description'   => __('The maximun number of post will be display on slider.', 'noo' ),
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => 'div',
            'value'         =>  10
        ),
        array(
            'param_name'    => 'button_name',
            'heading'       => __( 'Button Name', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'button_link',
            'heading'       => __( 'Button Link', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        )


    )
));

// noo event grid

vc_map(array(
    'base'        => 'noo_events_grid',
    'name'        => __( 'Noo Events Grid', 'noo' ),
    'class'       => 'noo-icon-events',
    'icon'        => 'noo-icon-events-grid',
    'category'    => $category_name,
    'description' => '',
    'params'      => array(
        array(
            'param_name'    =>  'icon',
            'heading'       =>  __('Choose icon', 'noo'),
            'description'   =>  '',
            'type'          =>  'iconpicker',
            'holder'        =>  'div'
        ),
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'cat',
            'heading'       => __('Categories Events', 'noo'),
            'description'   => '',
            'type'          => 'categories_events',
            'value'         => '',
            'horder'        => 'div',
            'admin_label'   => true
        ),
        array(
            'param_name'  => 'orderby',
            'heading'     => __( 'Order By', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       => array(
                __( 'Recent First', 'noo' )             => 'latest',
                __( 'Older First', 'noo' )              => 'oldest',
                __( 'Title Alphabet', 'noo' )           => 'alphabet',
                __( 'Title Reversed Alphabet', 'noo' )  => 'ralphabet' )
        ),
        array(
            'param_name'    => 'limit',
            'heading'       => __( 'Limited', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => 'div',
            'value'         =>  10
        )
    )
));


// noo featured albums

vc_map(array(
    'base'        => 'featured_albums',
    'name'        => __( 'Noo Featured Albums', 'noo' ),
    'class'       => 'noo-icon-albums',
    'icon'        => 'noo-icon-albums',
    'category'    => $category_name,
    'description' => '',
    'params'      => array(
        array(
            'param_name'    =>  'icon',
            'heading'       =>  __('Choose icon', 'noo'),
            'description'   =>  '',
            'type'          =>  'iconpicker',
            'holder'        =>  'div'
        ),
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'  => 'orderby',
            'heading'     => __( 'Order By', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       => array(
                __( 'Recent First', 'noo' )            => 'latest',
                __( 'Older First', 'noo' )             => 'oldest',
                __( 'Title Alphabet', 'noo' )          => 'alphabet',
                __( 'Title Reversed Alphabet', 'noo' ) => 'ralphabet' )
        ),
        array(
            'param_name'    => 'limit',
            'heading'       => __( 'Limited', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => 'div',
            'value'         =>  10
        )
    )
));

//[noo_our_blog]
add_filter( 'vc_autocomplete_noo_news_include_callback',
    'vc_include_field_search', 10, 1 ); // Get suggestion(find). Must return an array
add_filter( 'vc_autocomplete_noo_news_include_render',
    'vc_include_field_render', 10, 1 ); // Render exact product. Must return an array (label,value)
vc_map(array(
    'name'      =>  __('Noo news Blog','noo'),
    'base'      =>  'noo_news',
    'icon'      =>  'noo_icon_blog',
    'category'  =>   $category_name,
    'params'    =>  array(
        array(
            'param_name'    =>  'icon',
            'heading'       =>  __('Choose icon', 'noo'),
            'description'   =>  '',
            'type'          =>  'iconpicker',
            'holder'        =>  'div'
        ),
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    =>  'type_query',
            'heading'       =>  __('Data Source', 'noo'),
            'description'   =>  __('Select content type', 'noo'),
            'type'          =>  'dropdown',
            'admin_label'   => true,
            'holder'        =>  'div',
            'value'         =>  array(
                'Category'      =>  'cate',
                'Tags'          =>  'tag',
                'Posts'         =>  'post_id'
            )
        ),
        array(
            'param_name'    => 'categories',
            'heading'       => __( 'Categories', 'noo' ),
            'description'   => __('Select categories.', 'noo' ),
            'type'          => 'post_categories',
            'admin_label'   => true,
            'holder'        => 'div',
            'dependency'    => array(
                'element'   => 'type_query',
                'value'     => array( 'cate' )
            ),
        ),
        array(
            'param_name'    => 'tags',
            'heading'       => __( 'Tags', 'noo' ),
            'description'   => __('Select Tags.', 'noo' ),
            'type'          => 'post_tags',
            'admin_label'   => true,
            'holder'        => 'div',
            'dependency'    => array(
                'element'   => 'type_query',
                'value'     => array( 'tag' )
            ),
        ),
        array(
            'type'        => 'autocomplete',
            'heading'     => __( 'Include only', 'noo' ),
            'param_name'  => 'include',
            'description' => __( 'Add posts, pages, etc. by title.', 'noo' ),
            'admin_label'   => true,
            'holder'        => 'div',
            'settings' => array(
                'multiple' => true,
                'sortable' => true,
                'groups'   => true,
            ),
            'dependency'    => array(
                'element'   => 'type_query',
                'value'     => array( 'post_id' )
            ),
        ),
        array(
            'param_name'  => 'orderby',
            'heading'     => __( 'Order By', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       => array(
                __( 'Recent First', 'noo' )             => 'latest',
                __( 'Older First', 'noo' )              => 'oldest',
                __( 'Title Alphabet', 'noo' )           => 'alphabet',
                __( 'Title Reversed Alphabet', 'noo' )  => 'ralphabet' )
        ),
        array(
            'param_name'  => 'posts_per_page',
            'heading'     => __( 'Posts Per Page', 'noo' ),
            'description' => '',
            'type'        => 'textfield',
            'holder'      => 'div',
            'value'       => 10
        ),
        array(
            'param_name'   => 'limit_excerpt',
            'heading'      => __( 'Excerpt Length', 'noo' ),
            'description'  => '',
            'type'         => 'textfield',
            'holder'       => 'div',
            'value'        =>  15
        ),
    )
));


// Services
vc_map(array(
    'name'      =>  __('Noo Services','noo'),
    'base'      =>  'noo_services',
    'icon'      =>  'noo_icon_services',
    'category'  =>   $category_name,
    'params'    =>  array(
        array(
            'param_name'    =>  'icon',
            'heading'       =>  __('Choose icon', 'noo'),
            'description'   =>  '',
            'type'          =>  'iconpicker',
            'holder'        =>  'div'
        ),
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
    )
));

// Noo Line
vc_map(array(
    'name'      =>  __('Noo Line','noo'),
    'base'      =>  'noo_line',
    'icon'      =>  'noo_icon_line',
    'category'  =>   $category_name,
    'params'    =>  array(
        array(
            'param_name'    =>  'icon',
            'heading'       =>  __('Choose icon', 'noo'),
            'description'   =>  '',
            'type'          =>  'iconpicker',
            'holder'        =>  'div'
        )
    )
));

// Album Mansory
vc_map( 
	array( 
		'base'          => 'noo_album_masonry',
		'name'          => __( 'Album Masonry', 'noo' ),
		'weight'        => 660,
		'class'         => 'noo-vc-element noo-vc-element-portfolio',
		'icon'          => 'noo-vc-icon-portfolio',
		'category'      => $category_name,
		'description'   => '',
		'params'        => array(
			array( 
				"type"          => "textfield",
				"heading"       => __( "Product Per Page", 'noo' ),
				"param_name"    => "per_page",
				"admin_label"   => true,
				"value"         => 12 ),
			array( 
				'param_name'    => $param_visibility_name,
				'heading'       => $param_visibility_heading,
				'description'   => $param_visibility_description,
				'type'          => $param_visibility_type,
				'holder'        => $param_visibility_holder,
				'value'         => $param_visibility_value ),
			array( 
				'param_name'    => $param_class_name,
				'heading'       => $param_class_heading,
				'description'   => $param_class_description,
				'type'          => $param_class_type,
				'holder'        => $param_class_holder ),
			array( 
				'param_name'    => $param_custom_style_name,
				'heading'       => $param_custom_style_heading,
				'description'   => $param_custom_style_description,
				'type'          => $param_custom_style_type,
				'holder'        => $param_custom_style_holder ) ) ) );


//noo_team
$cat = array();
$cat['All'] = 'all';
if(class_exists('Noo_Post_Type')):
    $categories = get_categories( array( 'taxonomy'  => 'team_category' ) );
    if ( isset( $categories ) && !empty( $categories ) ):
        foreach( $categories as $cate ):
            $cat[ $cate->name ] = $cate -> term_id;
        endforeach;
    endif;
endif;
vc_map(array(
    'name'      =>  __('Noo Team','noo'),
    'base'      =>  'noo_team',
    'icon'      =>  'noo_icon_team',
    'category'  =>   $category_name,
    'params'    =>  array(
        array(
            'param_name'    => 'title',
            'heading'       => __( 'Title', 'noo' ),
            'description'   => '',
            'type'          => 'textfield',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'    => 'description',
            'heading'       => __( 'Description', 'noo' ),
            'description'   => '',
            'type'          => 'textarea',
            'admin_label'   => true,
            'holder'        => $param_holder
        ),
        array(
            'param_name'  => 'categories',
            'heading'     => __( 'Categories', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       =>  $cat
        ),

        array(
            'param_name'  => 'orderby',
            'heading'     => __( 'Order By', 'noo' ),
            'description' => '',
            'type'        => 'dropdown',
            'holder'      => 'div',
            'value'       => array(
                __( 'Recent First', 'noo' )             => 'latest',
                __( 'Older First', 'noo' )              => 'oldest',
                __( 'Title Alphabet', 'noo' )           => 'alphabet',
                __( 'Title Reversed Alphabet', 'noo' )  => 'ralphabet' )
        ),
        array(
            'param_name'  => 'limit',
            'heading'     => __( 'Limited Team Member', 'noo' ),
            'description' => '',
            'type'        => 'textfield',
            'holder'      => 'div',
            'value'       => 4
        ),
    )
));
