<?php
if(!class_exists('Noo_CPT')):
	abstract class Noo_CPT {

		/**
		 * Static property to hold our singleton instances
		 */
		private static $_instances = array();

		public static function instance() {
			$class = get_called_class();
			if (!isset(self::$_instances[$class])) {
				self::$_instances[$class] = new $class();
			}
			return self::$_instances[$class];
		}

		public static function loop_display( $args = '' ) {
			return self::instance()->_loop_display( $args );
		}

		public static function detail_display( $query = null ) {
			return self::instance()->_detail_display( $query );
		}

		public $post_type = 'noo_cpt';
		public $slug = 'cpts';

		protected function __construct(){

			add_filter( 'template_include', array( &$this, 'template_loader' ) );

			if( is_admin() ) {
				add_action('admin_init', array(&$this,'admin_init'));

				add_filter( 'enter_title_here', array (&$this,'custom_enter_title') );

				add_action( 'add_meta_boxes', array(&$this, 'remove_meta_boxes' ), 20 );
				add_action( 'add_meta_boxes', array(&$this, 'add_meta_boxes' ), 30 );

				add_filter('manage_edit-' . $this->post_type . '_columns', array(&$this, 'manage_edit_columns'));
				add_action('manage_posts_custom_column', array(&$this, 'manage_custom_column'));

				add_action( "{$this->post_type}_archive_customizer", array( &$this, 'customizer_add_archive_options' ) );
				add_action( "{$this->post_type}_single_customizer", array( &$this, 'customizer_add_single_options' ) );
			}
		}


		/////** FRONTEND **////
		protected function _loop_display( $args = '' ) {
			$defaults = array(
				'echo'=>true,
				'title'=>'',
				'excerpt_length'=>30
			);
			$args = wp_parse_args($args,$defaults);
			extract($args);
			ob_start();
			include(locate_template("layouts/{$this->post_type}-loop.php"));
			if($echo)
				echo ob_get_clean();
			else 
				return ob_get_clean();
		}

		protected function _detail_display($query = null) {

			if(empty($query)){
				global $wp_query;
				$query = $wp_query;
			}

			while ($query->have_posts()): $query->the_post(); global $post;
				include(locate_template("layouts/{$this->post_type}-detail.php"));
			endwhile;
			wp_reset_postdata();
		}

		public function template_loader($template){
			if( $this->is_archive() ) {
				$template       = locate_template( "archive-{$this->post_type}.php" );
			}
			return $template;
		}

		private function is_archive() {
			if( is_post_type_archive( $this->post_type ) ) 
				return true;

			global $noo_post_types;
			if( empty( $noo_post_types ) || !isset($noo_post_types[$this->post_type]) || !isset($noo_post_types[$this->post_type]['taxonomy']) ) {
				return false;
			}

			foreach ($noo_post_types[$this->post_type]['taxonomy'] as $taxonomy) {
				if( is_tax($taxonomy) ) return true;
			}

			return false;
		}

		/////** ADMIN **////
		public function admin_init() {

		}

		public function remove_meta_boxes() {
			// Remove slug and revolution slider

			// remove_meta_box( 'slugdiv', $this->post_type, 'normal' );
			// remove_meta_box( 'mymetabox_revslider_0', $this->post_type, 'normal' );
		}

		public function add_meta_boxes() {
		}

		public function manage_edit_columns($columns) {
			return $columns;
		}

		public function manage_custom_column($column) {
		}

		public function custom_enter_title( $title ) {
			global $noo_post_types;
			if( isset( $noo_post_types[$this->post_type] ) ) {
				$title = sprintf(__( 'Enter %s title', 'noo' ), $noo_post_types[$this->post_type]['singular_name'] );
			}

			return $title;
		}

		public function customizer_add_archive_options( $wp_customize ) {
			// noo_customizer_add_control(
			// 	$wp_customize,
			// 	array(
			// 		'id' => "{$this->post_type}_archive_number_columns",
			// 		'type' => 'select',
			// 		'label' => __( 'Number Columns', 'noo' ),
			// 		'default' => '2',
			// 		'control' => array(
			// 				'choices' => array(
			// 					2     => __( 'Two', 'noo' ),
			// 					3     => __( 'Three', 'noo' ),
			//                  4     => __( 'Four', 'noo' ),
			// 				)
			// 			),
			// 	)
			// );
		}

		public function customizer_add_single_options( $wp_customize ) {
		}
	}
endif;