<?php
/**
 * NOO Meta Boxes Package
 *
 * Setup NOO Meta Boxes for Post
 * This file add Meta Boxes to WP Post edit page.
 *
 * @package    NOO Framework
 * @subpackage NOO Meta Boxes
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */
if (!function_exists('noo_event_meta_boxes')):
    function noo_event_meta_boxes() {
        // Declare helper object
        $prefix = '_noo_wp_event';
        $helper = new NOO_Meta_Boxes_Helper($prefix, array(
            'page' => 'tribe_events'
        ));

        // Post type: Gallery
        $meta_box = array(
            'id' => "{$prefix}_meta_box_gallery",
            'title' => __('Event Gallery', 'noo'),
            'context'      => 'side',
            'priority'     => 'low',
            'fields' => array(
                array(
                    'id' => "{$prefix}_gallery",
                    // 'label' => __( 'Your Gallery', 'noo' ),
                    'type' => 'gallery',
                ),
                array(
                    'type' => 'divider',
                )
            )
        );

        $helper->add_meta_box($meta_box);

    }

endif;

add_action('add_meta_boxes', 'noo_event_meta_boxes');
