<?php
/**
 * Utilities Functions for NOO Framework.
 * This file contains various functions for getting and preparing data.
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */


//
// This function help to create the dynamic thumbnail width,
// but we don't use it at the moment.
//
if (!function_exists('noo_thumbnail_width')) :
	function noo_thumbnail_width() {
		$site_layout	= noo_get_option('noo_site_layout', 'fullwidth');
		$page_layout	= get_page_layout();
		$width			= 1200; // max width

		if($site_layout == 'boxed') {
			$site_width = (int) noo_get_option('noo_layout_site_width', '90');
			$site_max_width = (int) noo_get_option('noo_layout_site_max_width', '1200');
			$width = min($width * $site_width / 100, $site_max_width);
		}

		if($page_layout != 'fullwidth') {
			$width = $width * 75 / 100; // 75% of col-9
		}

		return $width;
	}
endif;

if (!function_exists('get_thumbnail_width')) :
	function get_thumbnail_width() {

		// if( is_admin()) {
		// 	return 'thumbnail';
		// }

		// NOO Portfolio
		if( is_post_type_archive( 'portfolio_project' ) ) {
			// if it's portfolio page, check if the masonry size is fixed or original
			if(noo_get_option('noo_portfolio_masonry_item_size', 'original' ) == 'fixed') {
				$masonry_size = noo_get_post_meta($post_id, '_noo_portfolio_image_masonry_size', 'regular');
				return "masonry-fixed-{$masonry_size}";
			}
		}

		$site_layout	= noo_get_option('noo_site_layout', 'fullwidth');
		$page_layout	= get_page_layout();

		if($site_layout == 'boxed') {
			if($page_layout == 'fullwidth') {
				return 'boxed-fullwidth';
			} else {
				return 'boxed-sidebar';
			}
		} else {
			if($page_layout == 'fullwidth') {
				return 'fullwidth-fullwidth';
			} else {
				return 'fullwidth-sidebar';
			}
		}

		return 'fullwidth-fullwidth';
	}
endif;


if(!function_exists('is_fullwidth')){
	function is_fullwidth(){
		return get_page_layout() == 'fullwidth';
	}
}

if (!function_exists('is_one_page_enabled')):
	function is_one_page_enabled() {
		if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
			$page_id = get_the_ID();
			return ( noo_get_post_meta( $page_id, '_noo_wp_page_enable_one_page', false ) );
		}

		return false;
	}
endif;

if (!function_exists('get_one_page_menu')):
	function get_one_page_menu() {
		if( is_one_page_enabled() ) {
			if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
				$page_id = get_the_ID();
				return noo_get_post_meta( $page_id, '_noo_wp_page_one_page_menu', '' );
			}
		}

		return '';
	}
endif;

if (!function_exists('has_home_slider')):
	function has_home_slider() {
		if (class_exists( 'RevSlider' )) {
			if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
				$page_id = get_the_ID();
				return ( noo_get_post_meta( $page_id, '_noo_wp_page_enable_home_slider', false ) )
					&& ( noo_get_post_meta( $page_id, '_noo_wp_page_slider_rev', '' ) != '' );
			}
		}

		return false;
	}
endif;

if (!function_exists('is_masonry_style')):
	function is_masonry_style() {
		if( is_post_type_archive( 'portfolio_project' ) || is_tax('portfolio_category') || is_tax('portfolio_tag')  ) {
			return true;
		}

		if(is_home()) {
			return (noo_get_option( 'noo_blog_style' ) == 'masonry');
		}

		if(is_archive()) {
			$archive_style = noo_get_option( 'noo_blog_archive_style', 'same_as_blog' );
			if ($archive_style == 'same_as_blog') {
				return (noo_get_option( 'noo_blog_style', 'standard' ) == 'masonry');
			} else {
				return ($archive_style == 'masonry');
			}
		}

		return false;
	}
endif;

if (!function_exists('get_page_heading')):
	function get_page_heading() {
		$heading = '';
		$archive_title = '';
		$archive_desc = '';
		if( ! noo_get_option( 'noo_page_heading', true ) ) {
			return array($heading, $archive_title, $archive_desc);
		}
		if ( is_home() ) {
			$heading = noo_get_option( 'noo_blog_heading_title', __( 'Blog', 'noo' ) );
		} elseif ( NOO_WOOCOMMERCE_EXIST && is_shop() ) {
			if( is_search() ) {
				$heading =__( 'Search', 'noo' );
			} else {
				$heading = noo_get_option( 'noo_shop_heading_title', __( 'Shop', 'noo' ) );
			}
		} elseif ( is_search() ) {
			$heading = __( 'Search', 'noo' );
// 			global $wp_query;
// 			if(!empty($wp_query->found_posts)) {
// 				if($wp_query->found_posts > 1) {
// 					$heading =  $wp_query->found_posts ." ". __('Search Results for:','noo')." ".esc_attr( get_search_query() );
// 				} else {
// 					$heading =  $wp_query->found_posts ." ". __('Search Result for:','noo')." ".esc_attr( get_search_query() );
// 				}
// 			} else {
// 				if(!empty($_GET['s'])) {
// 					$heading = __('Search Results for:','noo')." ".esc_attr( get_search_query() );
// 				} else {
// 					$heading = __('To search the site please enter a valid term','noo');
// 				}
// 			}
		} elseif ( is_author() ) {
			$curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));
			$heading = __('Author Archive','noo');

			//if(isset($curauth->nickname)) $heading .= ' ' . __('for:','noo')." ".$curauth->nickname;
		// } elseif ( is_tax( 'portfolio_category' ) || ( NOO_WOOCOMMERCE_EXIST && is_product_category() ) || is_category() ) {
		// 	$heading        = single_cat_title( '', false );
		// 	$archive_desc   = term_description();
		// } elseif ( is_tax( 'portfolio_tag' ) || ( NOO_WOOCOMMERCE_EXIST && is_product_tag() ) || is_tag() ) {
		// 	$heading        = single_cat_title( '', false );
		// 	$archive_desc   = term_description();
		} elseif ( is_year() ) {
    		$heading = __( 'Post Archive by Year: ', 'noo' ) . get_the_date( 'Y' );
		} elseif ( is_month() ) {
    		$heading = __( 'Post Archive by Month: ', 'noo' ) . get_the_date( 'F,Y' );
		} elseif ( is_day() ) {
    		$heading = __( 'Post Archive by Day: ', 'noo' ) . get_the_date( 'F j, Y' );
		} elseif ( is_404() ) {
    		$heading = __( 'Oops! We could not find anything to show to you.', 'noo' );
    		$archive_title =  __( 'Would you like going else where to find your stuff.', 'noo' );
		} elseif ( is_archive() ) {
			$heading        = single_cat_title( '', false );
			// $archive_desc   = term_description();
		} elseif ( is_singular( 'product' ) ) {
			$heading = noo_get_option( 'noo_woocommerce_product_disable_heading', true ) ? '' : get_the_title();
		}  elseif ( is_single() ) {
			$heading = noo_get_option( 'noo_blog_post_disable_heading', true ) ? '' : get_the_title();
		} elseif( is_page() ) {
			if( ! noo_get_post_meta(get_the_ID(), '_noo_wp_page_hide_page_title', false) ) {
				$heading = get_the_title();
			}
		}
		return array($heading, $archive_title, $archive_desc);
	}
endif;

if (!function_exists('get_page_heading_image')):
	function get_page_heading_image() {
		$image = '';
		if( ! noo_get_option( 'noo_page_heading', true ) ) {
			return $image;
		}
		if( NOO_WOOCOMMERCE_EXIST && is_shop() ) {
			$image = noo_get_image_option( 'noo_shop_heading_image', '' );
		} elseif ( is_home() ) {
			$image = noo_get_image_option( 'noo_blog_heading_image', '' );
		} elseif( is_category() || is_tag() ) {
			$queried_object = get_queried_object();
			$image			= noo_get_term_meta( $queried_object->term_id, 'heading_image', '' );
			$image			= empty( $image ) ? noo_get_image_option( 'noo_blog_heading_image', '' ) : $image;
		} elseif( is_tax( 'portfolio_category' ) ) {
			$queried_object = get_queried_object();
			$image			= noo_get_term_meta( $queried_object->term_id, 'heading_image', '' );
			$image			= empty( $image ) ? noo_get_image_option( 'noo_portfolio_heading_image', '' ) : $image;
		} elseif( NOO_WOOCOMMERCE_EXIST && ( is_product_category() || is_product_tag() ) ) {
			$queried_object = get_queried_object();
			$image			= noo_get_term_meta( $queried_object->term_id, 'heading_image', '' );
			$image			= empty( $image ) ? noo_get_image_option( 'noo_shop_heading_image', '' ) : $image;
		// 	$image = ! empty( $image ) ? $image : noo_get_image_option( 'noo_blog_heading_image', '' );
		} elseif ( is_singular('product' )) {
            $check_heading = noo_get_image_option('noo_shop_heading_image', '');
            if (isset($check_heading) && !empty($check_heading)) {
                $image = $check_heading;
            } else {
                $link_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                if (isset($link_image) && !empty($link_image)):
                    $image = $link_image[0];
                endif;
            }
        } elseif ( is_singular('tribe_events' )) {
            $check_heading = noo_get_image_option('noo_heading_event_image', '');
            if (isset($check_heading) && !empty($check_heading)) {
                $image = $check_heading;
            } else {
                $link_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                if (isset($link_image) && !empty($link_image)):
                    $image = $link_image[0];
                endif;
            }

        }elseif ( is_singular('noo_album' )) {
            $check_heading = noo_get_image_option( 'noo_heading_album_image', '' );
            if( isset( $check_heading ) && !empty($check_heading) ){
                $image = $check_heading;
            }else{
                $link_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                if (isset($link_image) && !empty($link_image)):
                    $image = $link_image[0];
                endif;
            }
        } elseif(is_page()){
            $image = noo_get_post_meta(get_the_ID(), '_heading_image', '' );
		}elseif( get_post_type() == 'tribe_events' ){
            $image = noo_get_image_option( 'noo_heading_event_image', '' );
        }elseif( is_post_type_archive( 'noo_album' ) || is_tax( 'album_artist' ) || is_tax( 'album_genre' ) || is_tax( 'album_produced' ) || is_tax( 'album_tag' ) ){
            $image = noo_get_image_option( 'noo_heading_album_image', '' );
        }elseif(is_single()){
            $check_heading = noo_get_image_option( 'noo_blog_heading_image', '' );
            if( isset( $check_heading ) && !empty($check_heading) ){
                $image = $check_heading;
            }else{
                $link_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                if (isset($link_image) && !empty($link_image)):
                    $image = $link_image[0];
                endif;
            }
        }

		if( !empty( $image ) && is_numeric( $image ) ) $image = wp_get_attachment_url( $image );
        if($image == '' && is_page()) {
            $image = NOO_ASSETS_URI.'/images/bg-heading-default.jpg';

        }
		return $image;
	}
endif;

if (!function_exists('noo_get_post_format')):
	function noo_get_post_format($post_id = null, $post_type = '') {
		$post_id = (null === $post_id) ? get_the_ID() : $post_id;
		$post_type = ('' === $post_type) ? get_post_type($post_id) : $post_type;

		$post_format = '';

		if ($post_type == 'post') {
			$post_format = get_post_format($post_id);
		}

		if ($post_type == 'portfolio_project') {
			$post_format = noo_get_post_meta($post_id, '_noo_portfolio_media_type', 'image');
		}

		return $post_format;
	}
endif;

if (!function_exists('has_featured_content')):
	function has_featured_content($post_id = null) {
		$post_id = (null === $post_id) ? get_the_ID() : $post_id;

		$post_type = get_post_type($post_id);
		$prefix = '';
		$post_format = '';

		if ($post_type == 'post') {
			$prefix = '_noo_wp_post';
			$post_format = get_post_format($post_id);
		}

		if ($post_type == 'portfolio_project') {
			$prefix = '_noo_portfolio';
			$post_format = noo_get_post_meta($post_id, "{$prefix}_media_type", 'image');
		}

		switch ($post_format) {
			case 'image':
				$main_image = noo_get_post_meta($post_id, "{$prefix}_main_image", 'featured');
				if( $main_image == 'featured') {
					return has_post_thumbnail($post_id);
				}

				return has_post_thumbnail($post_id) || ( (bool)noo_get_post_meta($post_id, "{$prefix}_image", '') );
			case 'gallery':
				if (!is_singular()) {
					$preview_content = noo_get_post_meta($post_id, "{$prefix}_gallery_preview", 'slideshow');
					if ($preview_content == 'featured') {
						return has_post_thumbnail($post_id);
					}
				}

				return (bool)noo_get_post_meta($post_id, "{$prefix}_gallery", '');
			case 'video':
				if (!is_singular()) {
					$preview_content = noo_get_post_meta($post_id, "{$prefix}_preview_video", 'both');
					if ($preview_content == 'featured') {
						return has_post_thumbnail($post_id);
					}
				}

				$m4v_video = (bool)noo_get_post_meta($post_id, "{$prefix}_video_m4v", '');
				$ogv_video = (bool)noo_get_post_meta($post_id, "{$prefix}_video_ogv", '');
				$embed_video = (bool)noo_get_post_meta($post_id, "{$prefix}_video_embed", '');

				return $m4v_video || $ogv_video || $embed_video;
			case 'link':
			case 'quote':
				return false;

			case 'audio':
				$mp3_audio = (bool)noo_get_post_meta($post_id, "{$prefix}_audio_mp3", '');
				$oga_audio = (bool)noo_get_post_meta($post_id, "{$prefix}_audio_oga", '');
				$embed_audio = (bool)noo_get_post_meta($post_id, "{$prefix}_audio_embed", '');
				return $mp3_audio || $oga_audio || $embed_audio;
			default: // standard post format
				return has_post_thumbnail($post_id);
		}

		return false;
	}
endif;
