<?php
/**
 * Theme functions for NOO Framework.
 * This file include the framework functions, it should remain intact between themes.
 * For theme specified functions, see file functions-<theme name>.php
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */

// Set global constance



if ( !defined( 'NOO_ASSETS' ) ) {
	define( 'NOO_ASSETS', get_template_directory() . '/assets' );
}

if ( !defined( 'NOO_ASSETS_URI' ) ) {
	define( 'NOO_ASSETS_URI', get_template_directory_uri() . '/assets' );
}

if ( !defined( 'NOO_VENDOR' ) ) {
	define( 'NOO_VENDOR', NOO_ASSETS . '/vendor' );
}

if ( !defined( 'NOO_VENDOR_URI' ) ) {
	define( 'NOO_VENDOR_URI', NOO_ASSETS_URI . '/vendor' );
}

define( 'NOO_INCLUDES', get_template_directory() . '/includes' );
define( 'NOO_INCLUDES_URI', get_template_directory_uri() . '/includes' );
define( 'NOO_FUNCTIONS', NOO_INCLUDES . '/functions' );

define( 'NOO_POST_TYPE', NOO_INCLUDES . '/post_type' );
define( 'NOO_POST_TYPE_URI', NOO_INCLUDES_URI . '/post_type' );

define( 'NOO_FRAMEWORK', NOO_INCLUDES . '/framework' );
define( 'NOO_FRAMEWORK_URI', NOO_INCLUDES_URI . '/framework' );

define( 'NOO_ADMIN_ASSETS', NOO_INCLUDES . '/admin_assets' );
define( 'NOO_ADMIN_ASSETS_URI', NOO_INCLUDES_URI . '/admin_assets' );

// Functions for specific theme
$theme_name = basename(dirname(__FILE__));

if ( !defined( 'NOO_THEME_NAME' ) ) {
	define( 'NOO_THEME_NAME', $theme_name );
}

define( 'NOO_WOOCOMMERCE_EXIST', class_exists( 'WC_API' ) );
define( 'NOO_SUPPORT_PORTFOLIO', false );

// Functions for specific theme
if ( file_exists( get_template_directory() . '/functions_custom.php' ) ) {
	require_once get_template_directory() . '/functions_custom.php';
}

// Theme setup
require_once NOO_INCLUDES . '/theme_setup.php';

// Meta Box
require_once NOO_INCLUDES .'/post_type/post-meta-boxes.php';
require_once NOO_INCLUDES .'/post_type/event-metabox.php';

//post type

require_once NOO_INCLUDES .'/post_type/team-meta-boxs.php';

require_once NOO_INCLUDES .'/post_type/noo_album.php';

//
// Init Framework.
//
require_once NOO_FRAMEWORK . '/_init.php';


//
// Enqueue assets
//
require_once NOO_FUNCTIONS . '/noo-enqueue-css.php';
require_once NOO_FUNCTIONS . '/noo-enqueue-js.php';

// Helper functions
require_once NOO_FUNCTIONS . '/noo-html.php';
require_once NOO_FUNCTIONS . '/noo-utilities.php';
require_once NOO_FUNCTIONS . '/noo-style.php';
require_once NOO_FUNCTIONS . '/noo-wp-style.php';
require_once NOO_FUNCTIONS . '/noo-mailchimp.php';
require_once NOO_FUNCTIONS . '/noo-user.php';
require_once NOO_FUNCTIONS . '/noo_social_counter.php';


// Custom post type: NOO Portfolio
if( NOO_SUPPORT_PORTFOLIO ) {
	// require_once NOO_POST_TYPE . '/noo-portfolio.php';
}

// WooCommerce

require_once NOO_INCLUDES . '/woocommerce.php';

// Visual Composer
require_once NOO_INCLUDES . '/vc_extension/vc_init.php';

//
// Widgets
//
$widget_path = get_template_directory() . '/widgets';

if ( file_exists( $widget_path . '/widgets_init.php' ) ) {
	require_once $widget_path . '/widgets_init.php';
	require_once $widget_path . '/widgets.php';
	require_once $widget_path . '/widget-counter.php';
}


if (class_exists('Tribe__Events__Tickets__Woo__Main')) {
    remove_action( 'tribe_events_single_event_after_the_meta', array( Tribe__Events__Tickets__Woo__Main::get_instance(), 'front_end_tickets_form'), 5 );
     add_action( 'tribe_events_single_event_after_the_content', array( Tribe__Events__Tickets__Woo__Main::get_instance(), 'front_end_tickets_form'), 5 );
}
include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Require plugin.php to use is_plugin_active() below
if( is_plugin_active( 'contact-form-7/wp-contact-form-7.php' ) ):
function add_event_to_cf7() {
    $html = '<select name="wpcf7-event" class="fs2">';

    $args = array(
        'post_type' => 'tribe_events',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'suppress_filters' => 0
    );
    $the_query = new WP_Query( $args );

    if ($the_query->have_posts()) {
        $html .= '<option class="item-first" value="0">' .  __('Selects Events', 'noo') . '</option>';
        while ($the_query->have_posts() ) {
            $the_query->the_post();

            $html .= '<option value="' . get_the_ID() . '">' . get_the_title() . '</option>';
        }
    }
    wp_reset_postdata();

    $html .='</select>';

    return $html;
}
wpcf7_add_shortcode('wpcf7_event', 'add_event_to_cf7', true);

endif;
?>
