<?php
get_header();
?>
<div class="container-wrap single-album">
	<div class="main-content container">
		<div class="row">
			<div class="noo-main col-md-12" role="main">
				<div id="album-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <h3 class="single-album-title"><?php _e('single album', 'noo'); ?></h3>
					<div class="row">
						<div class="album-intro col-xs-12">
							<div class="album-intro-wrap">
								<div class="images">
									<?php
										if ( has_post_thumbnail() ) {
											
											$image_title = esc_attr( get_the_title( get_post_thumbnail_id() ) );
											$image_link  = wp_get_attachment_url( get_post_thumbnail_id() );
											$image       = get_the_post_thumbnail( get_the_ID(), 'noo-thumbnail-square', array(
												'title' => $image_title
											) );
											
											echo sprintf( '<a href="%s" itemprop="image" class="noo_album-main-image" title="%s">%s</a>', $image_link, $image_title, $image );
								
											
										}
									?>
									<div class="album-purchase">
										<?php 
										if($_itunes_url = noo_get_post_meta(get_the_ID(),'_itunes_url')):
										?>
										<a href="<?php echo esc_url($_itunes_url)?>"><?php _e('iTunes','noo')?></a>
										<?php 
										endif;
										?>
										<?php 
										if($_amazon_url = noo_get_post_meta(get_the_ID(),'_amazon_url')):
										?>
										<a href="<?php echo esc_url($_amazon_url)?>"><?php _e('Amazon','noo')?></a>
										<?php 
										endif;
										?>
										<?php 
										if($_beatport_url = noo_get_post_meta(get_the_ID(),'_beatport_url')):
										?>
										<a href="<?php echo esc_url($_beatport_url)?>"><?php _e('Beatport','noo')?></a>
										<?php 
										endif;
										?>
									</div>
								</div>
								<div class="album-media-player">
									<?php 
									$songs = get_post_meta( get_the_ID(), '_noo_songs', true );
									if($songs):
									?>
                                    <h3 class="tracklist-title"><?php echo __('Tracklist', 'noo'); ?></h3>
									<div class="single-album-playlist">
										<ul>
											<?php
                                            $i = 1;
                                            foreach ($songs as $id=>$song):
                                            ?>

											<?php 
											if(has_post_thumbnail(get_the_ID())){
												$thumb       = get_the_post_thumbnail( get_the_ID(), 'shop_thumbnail_image_size', array(
													'title' => esc_attr( get_the_title( get_post_thumbnail_id() ) )
												) );
											}else{
												$thumb = '<img src="'.get_template_directory_uri().'/assets/images/no-track-image.png">';
											}
											?>
											<li data-album_id=<?php echo esc_attr(get_the_ID())?> id="<?php echo esc_attr($id)?>" data-id="<?php echo esc_attr($id)?>" data-artist="<?php echo esc_attr(get_the_term_list(get_the_ID(),'album_artist'))?>" data-genre="<?php echo esc_attr(get_the_term_list(get_the_ID(),'album_genre'))?>" data-file="<?php echo esc_url($song['file'])?>" data-thumb="<?php echo esc_attr($thumb)?>" data-name="<?php echo esc_attr($song['name'])?>" data-url="<?php echo esc_attr(get_permalink(get_the_ID()))?>" data-album="<?php echo esc_attr(get_the_title())?>">
												<a href="#" class="noodata-play"><span class="number"><?php echo esc_html($i); ?>.</span><span class="current-active-play"><i class="fa fa-play"></i></span><?php echo esc_html($song['name']); ?><?php if( isset($song['author']) && !empty($song['author']) ): ?><small> - <?php echo esc_html($song['author']); ?></small><?php endif; ?></a>
                                                <span class="album-meta">
                                                    <?php if( isset($song['itune']) && $song['itune'] !='' ): ?>
                                                        <a href="<?php echo esc_url($song['itune']); ?>">
                                                            <img class="drak" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/apple.png'); ?>" />
                                                            <img class="light" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/apple-light.png'); ?>" />
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if( isset($song['amazon']) && $song['amazon'] !='' ): ?>
                                                        <a href="<?php echo esc_url($song['amazon']) ?>">
                                                            <img class="drak"  src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/amazon.png'); ?>" />
                                                            <img class="light"  src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/amazon-light.png'); ?>" />
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if( isset($song['beatport']) && $song['beatport'] !='' ): ?>
                                                        <a href="<?php echo esc_url($song['beatport']); ?>">
                                                            <img class="drak" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/beatport.png'); ?>" />
                                                            <img class="light" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/beatport-light.png'); ?>" />
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if( isset($song['download']) && $song['download'] == 1 ): ?>
                                                        <a href="<?php echo esc_url($song['file']) ?>">
                                                            <img class="drak" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/download.png'); ?>" />
                                                            <img class="light" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/download-light.png'); ?>" />
                                                        </a>
                                                    <?php endif; ?>
                                                    <?php if( isset($song['soundcloud']) && $song['soundcloud'] == 1 ): ?>
                                                        <a href="<?php echo esc_url($song['soundcloud']); ?>">
                                                            <img class="drak" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/soundcloud.png'); ?>" />
                                                            <img class="light" src="<?php echo esc_attr(NOO_ASSETS_URI.'/images/soundcloud-light.png'); ?>" />
                                                        </a>
                                                    <?php endif; ?>
                                                </span>
											</li>
                                                <?php  $i++; ?>
											<?php endforeach;?>
										</ul>
									</div>
									<?php endif;?>
								</div>
							</div>
						</div>
						<div class="album-summary col-xs-12">
							<div class="row">
								<div class="col-sm-4">
									<div class="meta-summary">
										<div class="meta-artist">
											<?php _e('Artist:','noo')?>
											<span><?php echo get_the_term_list(get_the_ID(),'album_artist')?></span>
										</div>
										<?php if($_release_date = noo_get_post_meta(get_the_ID(),'_release_date','')):?>
										<div class="meta-release-date">
											<?php _e('Release date:','noo')?>
											<span><?php echo date_i18n(get_option( 'date_format' ),esc_attr($_release_date))?></span>
										</div>
										<?php endif;?>
										<div class="meta-genre">
											<?php _e('Genre:','noo')?>
											<span><?php echo get_the_term_list(get_the_ID(),'album_genre')?></span>
										</div>
										<div class="meta_artist">
											<?php _e('Produced:','noo')?>
											<span><?php echo get_the_term_list(get_the_ID(),'album_produced')?></span>
										</div>
										<div class="album-share content-social">
											<?php noo_social_share(get_the_ID())?>
										</div>
									</div>
								</div>
								<div class="col-sm-8">
									<div class="summary entry-summary">
										<h1 class="entry-title"><?php the_title(); ?></h1>
                                        <span class="author"><?php echo get_the_term_list(get_the_ID(),'album_artist')?></span>
										<div class="album-description">
											<?php 
											global $post;
											echo $post->post_content;
											?>
										</div>
										<div class="album-tag">
											<?php echo get_the_term_list(get_the_ID() ,'album_tag', '<span class="tagged_as">' . __( 'Tag:', 'noo' ) . ' ', '</span>' ); ?>
										</div>
									</div><!-- .summary -->
								</div>
							</div>
							
						</div>
					</div>
                    <div class="similar_album">
                        <h4 class="similar_title"><?php _e('similar', 'noo'); ?><span> <?php _e('album', 'noo'); ?></span></h4>
                        <div class="row">
                            <ul class="noo_albums">
                                <?php
                                    $cat = get_the_terms(get_the_ID(),'album_genre');
                                    if( isset($cat) && !empty($cat) ){
                                        if( isset($cat[0]->term_id) && !empty($cat[0]->term_id) ){

                                            $similar = array(
                                                'post_type'             =>  'noo_album',
                                                'posts_per_page'        =>   3,
                                                'ignore_sticky_posts'   =>  1,
                                                'tax_query'             =>  array(
                                                    array(
                                                        'taxonomy'  =>  'album_genre',
                                                        'field'     =>  'term_id',
                                                        'terms'     =>   array($cat[0]->term_id)
                                                    )
                                                ),
                                                'post__not_in'      =>  array(get_the_ID())
                                            );
                                            $similar_query = new WP_Query($similar);
                                            if( $similar_query->have_posts() ):
                                                while( $similar_query->have_posts() ):
                                                    $similar_query->the_post();
                                            ?>
                                                    <li class="col-md-4 col-sm-6">
                                                        <div class="noo_album-container">
                                                            <figure>
                                                                <div class="noo_album-wrap">
                                                                    <div class="noo_album-images">
                                                                        <a href="<?php the_permalink(); ?>">
                                                                            <?php
                                                                            if ( has_post_thumbnail() ) {
                                                                                echo get_the_post_thumbnail( get_the_ID(), 'noo-loop-album' );
                                                                            }
                                                                            ?>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                                <figcaption>
                                                                    <div class="noo_album-info">
                                                                        <h3 class="noo_album_title"><a href="<?php the_permalink()?>"><?php the_title(); ?></a></h3>
                                                                        <div class="noo_album-category"><?php echo get_the_term_list(get_the_ID(),'album_genre')?></div>
                                                                    </div>
                                                                    <div class="noo_album-loop-actions">
                                                                        <a href="<?php the_permalink(); ?>"><i class="fa fa-link"></i> <?php _e('Detail','noo') ; ?></a>
                                                                        <a href="#" data-songs='<?php echo esc_attr(Noo_Album::songs_to_playlist_data(get_the_ID()))?>' class="add-to-playlist-btn"><i class="fa fa-plus"></i> <?php _e('Add to Playlist','noo')?></a>
                                                                    </div>
                                                                </figcaption>
                                                            </figure>
                                                        </div>
                                                    </li>
                                            <?php
                                                endwhile;
                                            endif;
                                            wp_reset_postdata();
                                        }
                                    }
                                ?>
                            </ul>
                        </div>
                    </div>
				</div>
			</div> <!-- /.main -->
			<?php //get_sidebar(); ?>
		</div><!--/.row-->
	</div><!--/.container-boxed-->
</div><!--/.container-wrap-->
<?php
get_footer();
?>