<?php

    if(!function_exists('noo_shortcode_events')){
        function noo_shortcode_events($atts){
            extract(shortcode_atts(array(
                'title'         =>  '',
                'description'   =>  '',
                'cat'           =>  '',
                'orderby'       =>  '',
                'limit'         =>  '',
                'button_name'   =>  '',
                'button_link'   =>  ''
            ),$atts));
            ob_start();
            ?>
                <div class="noo-shortcode-events">
                    <?php if( isset($title) && !empty($title) ):
                            $array_title = explode(' ',$title);
                        ?>
                        <h2 class="sh-event-title">
                            <?php
                                if( isset($array_title) && !empty($array_title) ):
                                    $count = count($array_title);
                                    for($i = 0; $i < $count; $i++):
                                        if( $i != ( $count - 1 ) ){
                                            echo esc_html($array_title[$i]).' ';
                                        }else{
                                            echo '<span>'.esc_html($array_title[$i]).'</span>';
                                        }
                                    endfor;
                                endif;
                            ?>
                        </h2>
                    <?php endif; ?>
                    <?php if( isset($description) && !empty($description)): ?>
                        <p class="sh-ds"><?php echo esc_html($description) ?></p>
                    <?php endif; ?>
                    <div class="noo-sh-event-content">
                        <?php
                            $order = 'DESC';
                            switch ($orderby) {
                                case 'latest':
                                    $orderby = 'date';
                                    break;

                                case 'oldest':
                                    $orderby = 'date';
                                    $order   = 'ASC';
                                    break;

                                case 'alphabet':
                                    $orderby = 'title';
                                    $order   = 'ASC';
                                    break;

                                case 'ralphabet':
                                    $orderby = 'title';
                                    break;

                                default:
                                    $orderby = 'date';
                                    break;
                            }

                            $args = array(
                                'post_type'         =>  'tribe_events',
                                'orderby'           =>  $orderby,
                                'order'             =>  $order,
                                'posts_per_page'    =>  $limit,
                            );
                            $cat_id = '';
                            if( isset($cat) && !empty($cat) && $cat != 'all'){
                                $cat_id = explode(',',$cat);
                                $args['tax_query'][]  =    array(
                                    'taxonomy'  =>  'tribe_events_cat',
                                    'field'     =>  'term_id',
                                    'terms'     =>  $cat_id
                                );
                            }
                            $query = new WP_Query( $args );
                            if( $query->have_posts() ):
                                while( $query->have_posts() ):
                                    $query->the_post();
                                    $link_img = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'noo-thumbnail-square');
                        ?>
                        <div class="noo-sh-list-event">
                            <span class="entry-date">
                                    <?php echo get_the_date('d'); ?>
                                <span class="month">
                                        <?php echo get_the_date('F'); ?>
                                    </span>
                                </span>
                            <div class="noo-thumbnail" <?php if( isset($link_img[0]) && !empty($link_img[0]) ): ?>style="background-image: url('<?php echo esc_url($link_img[0]); ?>')" <?php endif; ?>></div>
                            <div class="noo-shevent-content">
                                <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                                <div class="sh-meta">
                                    <span class="sh-date"><i class="fa fa-clock-o"></i><?php  echo tribe_events_event_schedule_details( get_the_ID()); ?></span>
                                    <span class="sh-address"><i class="fa  fa-map-marker"></i><?php echo tribe_get_venue(get_the_ID()).', '.tribe_get_address( get_the_ID() )  ; ?></span>
                                </div>
                                <div class="sh-excerpt">
                                    <?php the_excerpt() ?>
                                </div>
                            </div>
                        </div>
                        <?php
                            endwhile;
                        endif; wp_reset_postdata();
                        ?>
                        <?php if( isset($button_name) && !empty($button_name) ): ?>
                            <div class="noo-view-event">
                                <a href="<?php echo esc_url($button_link); ?>"><?php echo esc_html($button_name) ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php
            $events = ob_get_contents();
            ob_end_clean();
            return $events;
        }
        add_shortcode('noo_events_list','noo_shortcode_events');
    }


?>