<?php

if(!function_exists('noo_shortcode_events_grid')){
    function noo_shortcode_events_grid($atts){
        extract(shortcode_atts(array(
            'title'         =>  '',
            'icon'          =>  'fa fa-calendar',
            'description'   =>  '',
            'cat'           =>  '',
            'orderby'       =>  '',
            'limit'         =>  ''
        ),$atts));
        ob_start();
        ?>
        <div class="noo-shortcode-events grid">
            <div class="noo-grid-header-events">
                <span class="icon">
                    <i class="<?php echo esc_attr($icon) ?>"></i>
                </span>
                <?php if( isset($title) && !empty($title) ): ?>

                    <h2 class="sh-event-title">
                        <?php echo esc_html($title); ?>
                    </h2>
                <?php endif; ?>
                <?php if( isset($description) && !empty($description)): ?>
                    <p class="sh-ds"><?php echo esc_html($description) ?></p>
                <?php endif; ?>
            </div>
            <div class="noo-sh-event-content row">
                <?php
                $order = 'DESC';
                switch ($orderby) {
                    case 'latest':
                        $orderby = 'date';
                        break;

                    case 'oldest':
                        $orderby = 'date';
                        $order   = 'ASC';
                        break;

                    case 'alphabet':
                        $orderby = 'title';
                        $order   = 'ASC';
                        break;

                    case 'ralphabet':
                        $orderby = 'title';
                        break;

                    default:
                        $orderby = 'date';
                        break;
                }

                $args = array(
                    'post_type'         =>  'tribe_events',
                    'orderby'           =>  $orderby,
                    'order'             =>  $order,
                    'posts_per_page'    =>  $limit,
                );
                $cat_id = '';
                if( isset($cat) && !empty($cat) && $cat != 'all'){
                    $cat_id = explode(',',$cat);
                    $args['tax_query'][]  =    array(
                        'taxonomy'  =>  'tribe_events_cat',
                        'field'     =>  'term_id',
                        'terms'     =>  $cat_id
                    );
                }
                $query = new WP_Query( $args );
                if( $query->have_posts() ):
                    while( $query->have_posts() ):
                        $query->the_post();
                        ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="noo-sh-grid-event">
                                <div class="noo-thumbnail">
                                    <?php the_post_thumbnail('large') ?>
                                </div>
                                <div class="noo-shevent-content">
                                    <h4><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h4>
                                    <div class="sh-meta">
                                        <span class="sh-time-event"><i class="fa fa-clock-o"></i><?php  echo tribe_events_event_schedule_details( get_the_ID()); ?></span>
                                        <span class="sh-address"><i class="fa  fa-map-marker"></i><?php echo tribe_get_venue(get_the_ID()).', '.tribe_get_address( get_the_ID() )  ; ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif; wp_reset_postdata();
                ?>
            </div>
        </div>
        <?php
        $events = ob_get_contents();
        ob_end_clean();
        return $events;
    }
    add_shortcode('noo_events_grid','noo_shortcode_events_grid');
}


?>