<?php

    if(!function_exists('noo_shortcode_countdown')){

        function noo_shortcode_countdown($attrs){
            extract(shortcode_atts(array(
                'date'              =>  '',
                'title'             =>  '',
                'description'       =>  '',
                'button_name'       =>  '',
                'button_link'       =>  '',
                'background'        =>  '',
                'parallax_image'    =>  '',
                'overlay_parallax'  =>  '',
                'link_youtube'      =>  '',
                'back_youtube'      =>  '',
                'slider_image'      =>  '',
                'slider_height'     =>  '',
                'height_custom'     =>  '',
            ),$attrs));
            ob_start();
            wp_enqueue_script('vendor-countdown-plugin');
            wp_enqueue_script('vendor-countdown-js');
            if( $background =='youtube' ):
                wp_enqueue_script('vendor-YTPlayer-js');
            endif;
            if( isset($background) && $background=='parallax'):
                wp_enqueue_script('noo-tweenLite');
                wp_enqueue_script('noo-EasePack');
                wp_enqueue_script('noo-rAF');
                wp_enqueue_script('noo-effect');
            endif;
            $date_time = '';
            if( isset($date) && $date != '' ){
                $date_time = explode('/',$date);
            }

            $customheight = 'auto';
            if( $slider_height == 2 ){
                $customheight = $height_custom.'px';
            }
            $class_parallax = '';
            if ( $background == 'parallax' ):
                $class_parallax = "parallax ";
                wp_enqueue_script('vendor-parallax');
            endif;
            $image_id = '';

            ?>
            <div class="noo-countdown <?php echo esc_attr($class_parallax) ?>" style="height: <?php echo esc_attr($customheight); ?> <?php if( isset($background) && $background=='parallax'): ?>; background-image: url('<?php echo esc_url(wp_get_attachment_url($parallax_image)); ?>')<?php endif; ?>">
                <?php if( isset($background) && $background=='parallax'): ?>
                    <div id="large-header" class="large-header">
                        <canvas id="demo-canvas"></canvas>
                    </div>
                <?php endif; ?>
                <?php if( isset($slider_image) && !empty($slider_image) && $background =='slider'){
                        $image_id = explode(',',$slider_image);
                    ?>
                        <ul class="full-background">
                            <?php foreach($image_id as $id): ?>
                                <li style="background-image: url('<?php echo wp_get_attachment_url(esc_attr($id)); ?>')"></li>
                            <?php endforeach; ?>
                        </ul>
                <?php } ?>
                <?php if( $background =='youtube' && $link_youtube != '' ): ?>
                    <a  id="bgndVideo" class="player" data-property="{videoURL:'<?php echo esc_url($link_youtube); ?>',containment:'.noo-countdown',autoPlay:true, mute:true, startAt:0, opacity:1}"></a>
                    <?php if( isset($back_youtube) && $back_youtube !='' ): ?><div class="background-mobi" style="background-image: url('<?php echo esc_url(wp_get_attachment_url($back_youtube)); ?>')"></div><?php endif; ?>
                <?php endif; ?>
                <div class="overlay_parallax" style="background-color: <?php echo esc_attr($overlay_parallax); ?>"></div>
                <div class="noo-countdown-content">
                    <div class="container">
                        <?php if( isset($title) && $title !='' ): ?><h2><?php echo esc_html($title); ?></h2><?php endif; ?>
                        <?php if( isset($description) && $description != '' ): ?><p><?php echo esc_html($description) ?></p><?php endif; ?>

                        <!-- Countdown dashboard start -->
                        <div id="defaultCountdown"></div>
                        <!-- Countdown dashboard end -->
                        <?php if( isset($button_name) && $button_name != '' ): ?>
                        <div class="noo-countdown-footer">
                            <a href="<?php echo esc_url($button_link); ?>" data-text="<?php echo esc_html($button_name); ?>"><span><?php echo esc_html($button_name); ?></span></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <script type="text/javascript">
                <?php   if( $slider_height == 1 ){ ?>
                    var $height_w   = jQuery(window).height();
                    jQuery('.noo-countdown').css('height',$height_w+'px');
                    jQuery(window).resize(function(){
                        var $height_w = jQuery(window).height();
                        jQuery('.noo-countdown').css('height',$height_w+'px');
                    });
                <?php } ?>
                jQuery(function () {
                    <?php if( $background !='parallax' ): ?>
                        jQuery('.full-background li:first-child').show();
                        var myVar = '';
                        clearInterval(myVar);
                        myVar = setInterval(function(){
                            jQuery('.full-background li:first-child').fadeOut(1200).next('li').fadeIn(1200).end().appendTo('.full-background');
                        },3500);
                    <?php endif; ?>

                    <?php if( $background =='youtube' ): ?>

                    var onMobile = false;
                    if( /Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent) ) { onMobile = true; }

                    if( ( onMobile === false ) ) {

                        jQuery(".player").mb_YTPlayer();

                    } else {
                        /* as a fallback we add a special class to the header which displays a poster image */
                        jQuery('.noo-countdown').addClass('video-section');

                    }
                    <?php endif; ?>
                    
                    austDay = new Date(<?php if( isset($date_time) && $date_time[2] !=''){ echo esc_attr($date_time[2]); } ?>, <?php if( isset($date_time) && $date_time[0] !=''){ echo esc_attr($date_time[0]); } ?> - 1,  <?php if( isset($date_time) && $date_time[1] !=''){ echo esc_attr($date_time[1]); } ?>);
                    jQuery('#defaultCountdown').countdown({until: austDay});
                    jQuery('#year').text(austDay.getFullYear());


                });

            </script>

            <?php
            $countdown = ob_get_contents();
            ob_end_clean();
            return $countdown;
        }
        add_shortcode('noo_countdown', 'noo_shortcode_countdown');

    }

?>