<?php

    if(!function_exists('noo_shortcode_news')){

        function noo_shortcode_news($atts){
            extract(shortcode_atts(array(
                'title'             =>  '',
                'icon'              =>  'fa fa-calendar',
                'description'       =>  '',
                'type_query'        =>  '',
                'categories'        =>  '',
                'tags'              =>  '',
                'include'           =>  '',
                'orderby'           =>  '',
                'posts_per_page'    =>  '',
                'limit_excerpt'     =>   20
            ),$atts));
            ob_start();
            $order = 'DESC';
            switch ($orderby) {
                case 'latest':
                    $orderby = 'date';
                    break;

                case 'oldest':
                    $orderby = 'date';
                    $order   = 'ASC';
                    break;

                case 'alphabet':
                    $orderby = 'title';
                    $order   = 'ASC';
                    break;

                case 'ralphabet':
                    $orderby = 'title';
                    break;

                default:
                    $orderby = 'date';
                    break;
            }
            $args = array(
                'post_type'         =>  'post',
                'orderby'           =>   $orderby,
                'order'             =>   $order,
                'posts_per_page'    =>   $posts_per_page,
            );

            if($type_query == 'cate'){
                $args['cat']   =  $categories ;
            }
            if($type_query == 'tag'){
                if($tags != 'all'):
                    $tag_id = explode (',' , $tags);
                    $args['tag__in'] = $tag_id;
                endif;
            }
            if($type_query == 'post_id'){
                $posts_var = '';
                if ( isset($include) && !empty($include) ){
                    $posts_var = explode (',' , $include);
                }
                $args['post__in'] = $posts_var;
            }
            $query = new WP_Query( $args );
            ?>
            <div class="noo-grid-header-events header-news">
                    <span class="icon">
                        <i class="<?php echo esc_attr($icon) ?>"></i>
                    </span>
                <?php if( isset($title) && !empty($title) ): ?>

                    <h2 class="sh-event-title">
                        <?php echo esc_html($title); ?>
                    </h2>
                <?php endif; ?>
                <?php if( isset($description) && !empty($description)): ?>
                    <p class="sh-ds"><?php echo esc_html($description) ?></p>
                <?php endif; ?>
            </div>
            <?php
            if( $query->have_posts() ):
                echo '<ul CLASS="noo_news_blog">';
                while( $query->have_posts() ): $query->the_post();
                    ?>
                    <li>
                        <div class="noo-sh-thumbail">
                            <div class="shthumbail">
                                <?php the_post_thumbnail('noo-thumbnail-square') ?>
                            </div>
                        </div>
                        <div class="noo-sh-blog-content">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <?php noo_content_meta(); ?>
                            <?php
                            $excerpt         = get_the_excerpt();
                            $excerpt_ex      = explode(' ', $excerpt);
                            $excerpt_slice   = array_slice($excerpt_ex,0,$limit_excerpt);
                            $excerpt_content = implode(' ',$excerpt_slice);
                            ?>
                            <p><?php echo esc_html($excerpt_content); ?></p>
                            <a class="read-more" href="<?php the_permalink(); ?>"><?php _e('Continue Reading...','noo'); ?></a>
                        </div>
                    </li>
                <?php
                endwhile;
                echo '</ul>';
            endif; wp_reset_postdata();

            $blog = ob_get_contents();
            ob_end_clean();
            return $blog;
        }
        add_shortcode('noo_news','noo_shortcode_news');
    }

?>