<?php
/**
 * Initialize Theme functions for NOO Themes.
 *
 * @package    NOO Themes
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */

// Content Width
if ( ! isset( $content_width ) ) :
	$content_width = 970;
endif;

// Initialize Theme
if (!function_exists('noo_init_theme')):
	function noo_init_theme() {
		load_theme_textdomain( 'noo', get_template_directory() . '/languages' );

		require_once( 'noo-check-version.php' );
 
        if ( is_admin() ) {     
            $license_manager = new Noo_Check_Version(
                'noo-wemusic',
                'NOO Wemusic',
                'http://update.nootheme.com/api/license-manager/v1'
            );
        }

		// Title Tag -- From WordPress 4.1.
		add_theme_support('title-tag');
		// @TODO: Automatic feed links.
		add_theme_support('automatic-feed-links');
		// Add support for some post formats.


		add_theme_support('post-formats', array(
			'image',
			'gallery',
			'video',
			'audio',
			'quote'
		));

		add_theme_support( 'woocommerce' );

		// WordPress menus location.
		$menu_list = array();
		
		$menu_list['primary'] = __('Primary Menu', 'noo');

		if (noo_get_option( 'noo_header_top_bar', false ) && (noo_get_option('noo_top_bar_type', 'menu') == 'menu') ) {
			$menu_list['top-menu'] = __('Top Menu', 'noo');
		}
		
		if (noo_get_option('noo_footer_top', false)) {
			$menu_list['footer-menu'] = __('Footer Menu', 'noo');
		}

		// Register Menu
		register_nav_menus($menu_list);

		// Define image size
		add_theme_support('post-thumbnails');
		
		add_image_size('noo-thumbnail-square',600,450, true);
		add_image_size('noo-single-album',500,700, true);
		add_image_size('noo-loop-album',500,700, true);

		$default_values = array( 
				'primafy_color' => '#d91f26',
				'secondary_color' => '#000',
				'font_family' => 'Dosis',
				'text_color' => '#fff',
				'font_size' => '16',
				'font_weight' => '400',
				'headings_font_family' => 'Dosis',
				'headings_color' => '#000',
				'logo_color' => '#000',
				'logo_font_family' => 'Dosis',
			);
		noo_set_theme_default( $default_values );
	}
	add_action('after_setup_theme', 'noo_init_theme');
endif;

// Deactivate libraries plugins
// This function used when moving custom post type from plugin to theme
if ( ! function_exists( 'noo_deactivate_plugins' ) ) :
	function noo_deactivate_plugins() {

	}

endif;