<?php
/**
 * NOO Meta Boxes Package
 *
 * Setup NOO Meta Boxes for Page
 * This file add Meta Boxes to WP Page edit page.
 *
 * @package    NOO Framework
 * @subpackage NOO Meta Boxes
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */

if (!function_exists('noo_page_meta_boxes')):
	function noo_page_meta_boxes() {
		// Declare helper object
		$prefix = '_noo_wp_page';
		$helper = new NOO_Meta_Boxes_Helper($prefix, array(
			'page' => 'page'
		));

		// Page Settings
		$meta_box = array(
			'id' => "{$prefix}_meta_box_page",
			'title' => __('Page Settings', 'noo') ,
			'description' => __('Choose various setting for your Page.', 'noo') ,
			'fields' => array(
				array(
					'label' => __('Body Custom CSS Class', 'noo') ,
					'id' => "_noo_body_css",
					'type' => 'text',
				),
				array(
					'label' => __('Hide Page Title', 'noo') ,
					'id' => "{$prefix}_hide_page_title",
					'type' => 'checkbox',
				),
				array(
					'type' => 'divider'
				),
				array(
					'id'    => "{$prefix}_menu_transparent",
					'label' => __( 'Enable Menu Transparent' , 'noo' ),
					'desc'  => __( 'Enable Menu Transparent.', 'noo' ),
					'type'  => 'checkbox',
					'std'   => 'off',
					'child-fields' => array(
						'on'   => "{$prefix}_menu_transparent_logo"
					)
				),
				array(
					'id'    => "{$prefix}_menu_transparent_logo",
					'label' => __( 'Menu Logo' , 'noo' ),
					'desc'  => __( 'Menu Logo.', 'noo' ),
					'type'  => 'image',
				),
			)
		);

		if( noo_get_option('noo_page_heading', true) ) {
			$meta_box['fields'][] = array(
								'id'    => '_heading_image',
								'label' => __( 'Heading Background Image', 'noo' ),
								'desc'  => __( 'An unique heading image for this page', 'noo'),
								'type'  => 'image',
							);
		}

		$helper->add_meta_box($meta_box);

		//
		// Revolution Sliders
		//
		if ( class_exists( 'RevSlider' ) ) {
			// Home Slider
			$meta_box = array(
				'id' => "{$prefix}_meta_box_home_slider",
				'title' => __('Home Slider', 'noo'),
				'fields' => array(
					array(
					'id'    => "{$prefix}_enable_home_slider",
					'label' => __( 'Enable Home Slider' , 'noo' ),
					'desc'  => __( 'Enable Home Slider which displays on the top of your site above the Header.', 'noo' ),
					'type'  => 'checkbox',
					'std'   => 'off',
					'child-fields' => array(
							'on'   => "{$prefix}_slider_rev,{$prefix}_slider_custom_bg"
						)
					),
					array(
						'label' => __( 'Revolution Slider', 'noo' ),
						'desc' => __( 'Select a Slider from Revolution Slider.', 'noo' ),
						'id'   => "{$prefix}_slider_rev",
						'type' => 'rev_slider',
						'std'  => ''
					),
					array(
						'label' => __('Use custom background video?', 'noo') ,
						'id' => "{$prefix}_slider_custom_bg",
						'type' => 'checkbox',
						'child-fields' => array(
							'on' => "{$prefix}_slider_bg_video,{$prefix}_slider_bg_video_poster"
							)
					),
					array(
						'label' => __( 'Background Video', 'noo' ),
						'desc' => __( 'Input the URL to your .mp4 video file.', 'noo' ),
						'id'   => "{$prefix}_slider_bg_video",
						'type' => 'text',
						'std'  => ''
					),
					array(
						'label' => __( 'Video Poster Image (on Mobile)', 'noo' ),
						'desc' => __( 'The poster image is used on Mobile where the background video is not available', 'noo' ),
						'id'   => "{$prefix}_slider_bg_video_poster",
						'type' => 'image',
						'std'  => ''
						)
				)
			);

			$helper->add_meta_box($meta_box);
		}

		// Page Sidebar
		$meta_box = array(
			'id' => "{$prefix}_meta_box_sidebar",
			'title' => __('Sidebar', 'noo'),
			'context'      => 'side',
			'priority'     => 'default',
			'fields' => array(
				array(
					'label' => __('Page Sidebar', 'noo') ,
					'id' => "{$prefix}_sidebar",
					'type' => 'sidebars',
					'std' => 'sidebar-main'
				) ,
			)
		);

		$helper->add_meta_box( $meta_box );
	}
endif;

add_action('add_meta_boxes', 'noo_page_meta_boxes');