<?php

if ( ! class_exists( 'NooPost' ) ) :

	class NooPost {
		public static $top_level_cat_list = array();
		public function __construct() {

			if ( is_admin() ) {
				add_filter( 'manage_edit-post_columns', array(&$this,'featured_columns') );
				add_filter( 'manage_post_posts_custom_column', array(&$this,'featured_column'), 2 );
				add_action( 'add_meta_boxes', array(&$this, 'meta_boxes') );

				// Ajax for featured post
				add_action( 'wp_ajax_noo_featured_post', array(&$this, 'ajax_featured') );
			}

			add_action('wp_ajax_noo_ajax_loadmore', array(&$this, 'ajax_loadmore'));
			add_action('wp_ajax_nopriv_noo_ajax_loadmore', array(&$this, 'ajax_loadmore'));
		}

		public function meta_boxes() {
			$helper = new NOO_Meta_Boxes_Helper('', array(
				'page' => 'post'
			));

			$meta_box = array(
				'id' => "_meta_box_featured",
				'title' => __('Featured Post', 'noo'),
				'context'      => 'side',
				'priority'     => 'core',
				'fields' => array(
					array(
						'label' => __('Is featured post', 'noo'),
						'id' => "_noo_feature",
						'type' => 'checkbox',
					),
				)
			);
			$helper->add_meta_box($meta_box);
		}

		public function featured_columns( $columns ) {
			$before = array_slice($columns, 0, 2);
			$after = array_slice($columns, 2);
			
			$featured_column = array(
				'featured' => __('Featured', 'noo')
			);
			
			$columns = array_merge($before, $featured_column, $after);
			return $columns;
		}
		
		public function featured_column( $column) {
			global $post;
			$featured = noo_get_post_meta($post->ID,'_noo_feature', false);
		
			if ( $column == 'featured' ) {
				$url = wp_nonce_url( admin_url( 'admin-ajax.php?action=noo_featured_post&post_id=' . $post->ID ), 'noo-post-feature' );
				echo '<a href="' . esc_url( $url ) . '" title="'. __( 'Toggle featured', 'noo' ) . '">';
				if ( $featured && $featured !== 'off' ) {
					echo '<span class="noo-post-feature" title="'.esc_attr('Yes','noo').'"><i class="dashicons dashicons-star-filled "></i></span>';
				} else {
					echo '<span class="noo-post-feature not-featured"  title="'.esc_attr('No','noo').'"><i class="dashicons dashicons-star-empty"></i></span>';
				}
				echo '</a>';
			}
			return $column;
		}
		
		public function ajax_featured(){
			if ( ! check_admin_referer( 'noo-post-feature' ) ) {
				wp_die( __( 'You have taken too long. Please go back and retry.', 'noo' ), '', array( 'response' => 403 ) );
			}

			$post_id = ! empty( $_GET['post_id'] ) ? (int) $_GET['post_id'] : '';

			if ( ! $post_id || get_post_type( $post_id ) !== 'post' ) {
				die;
			}

			$featured = noo_get_post_meta( $post_id, '_noo_feature', true );

			if ( $featured && $featured !== '0' ) {
				update_post_meta( $post_id, '_noo_feature', '0' );
			} else {
				update_post_meta( $post_id, '_noo_feature', '1' );
			}


			wp_safe_redirect( esc_url( remove_query_arg( array( 'trashed', 'untrashed', 'deleted', 'ids' ), wp_get_referer() ) ) );
			die();
		}

		private function _ajax_exit( $data = '', $success = false, $redirect = '' ) {
			$response = array(
				'success' => $success,
				'data' => $data,
			);

			if( !empty( $redirect ) ) {
				$response['redirect'] = $redirect;
			}

			echo json_encode($response);
			exit();
		}

		public static function get_top_level_category( $category_id = 0 ) {
			if( empty($category_id) ) return 0;

			if( !isset(self::$top_level_cat_list[$category_id]) ) {
				$category = get_term_by( 'id', $category_id, 'category');

			    // climb up the hierarchy until we reach a term with parent = '0'
				while ($category->parent != '0'){
					$parent  = get_term_by( 'id', $category->parent, 'category');
					$category = $parent;
				}

				self::$top_level_cat_list[$category_id] = $category;
			}
			return self::$top_level_cat_list[$category_id];
		}

		public static function get_category_label( $class = '', $color_style = false ) {
			$post_category = get_the_category();
			if(!empty($post_category)) {
				$post_category = reset($post_category);
				$category_parent = self::get_top_level_category($post_category->term_id);
				if(!empty($category_parent)):
					$color = noo_get_term_meta( $category_parent->term_id, 'category_color', '' );
					$cat_name =  $category_parent->term_id;
				else:
					$color = noo_get_term_meta( $post_category->term_id, 'category_color', '' );
					$cat_name =  $post_category->cat_ID;
				endif;
				$class = !empty( $class ) ? 'class="' . esc_attr( $class ) . '"' : 'class="item-category"';
				$style = $color_style ? 'style="color: ' . $color . ';"' : 'style="background-color: ' . $color . ';"';
				return '<a ' . $class . ' '  . $style . ' href="' . get_category_link($cat_name) .'"><i>'.get_cat_name($cat_name) .'</i></a>';
			}

			return '';
		}
	}
endif;

new NooPost();