<?php
/**
 * Mega Menu.
 * This file create and manager addtional options for Menu items, option which enable mega menu function.
 *
 * @package    NOO Framework
 * @subpackage Mega Menu
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */


class Noo_Walker_CategoryDropdown extends Walker {

	var $tree_type = 'category';
	var $db_fields = array ('parent' => 'parent', 'id' => 'term_id', 'slug' => 'slug' );

	public function start_el( &$output, $cat, $depth = 0, $args = array(), $current_object_id = 0 ) {

		if ( ! empty( $args['hierarchical'] ) )
			$pad = str_repeat('-', $depth * 2);
		else
			$pad = '';

		$cat_name = $cat->name;

		$value = isset( $args['value'] ) && $args['value'] == 'id' ? $cat->term_id : $cat->slug;

		$output .= "\t<option class=\"level-$depth\" value=\"" . $value . "\"";

		if ( $value == $args['selected'] || ( is_array( $args['selected'] ) && in_array( $value, $args['selected'] ) ) )
			$output .= ' selected="selected"';

		$output .= '>';

		$output .= $pad . $cat_name;

		if ( ! empty( $args['show_count'] ) )
			$output .= '&nbsp;(' . $cat->count . ')';

		$output .= "</option>\n";
	}

	public function display_element( $element, &$children_elements, $max_depth, $depth = 0, $args, &$output ) {
		if ( ! $element || 0 === $element->count ) {
			return;
		}
		parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
}

// Enqueue script for Mega Menu admin
if ( ! function_exists( 'noo_enqueue_mega_menu_js' ) ) :
	function noo_enqueue_mega_menu_js( $hook ) {
		if ( $hook != 'nav-menus.php' ) {
			return;
		}

		// Enqueue style for Mega Menu admin
		wp_register_style( 'noo-mega-menu-admin-css', NOO_ADMIN_ASSETS_URI . '/css/noo-mega-menu-admin.css' );
		wp_enqueue_style( 'noo-mega-menu-admin-css' );

		wp_register_script( 'noo-mega-menu-admin-js', NOO_ADMIN_ASSETS_URI . '/js/noo-mega-menu-admin.js', null, null, true );
		wp_enqueue_script( 'noo-mega-menu-admin-js' );
	}
endif;
add_action( 'admin_enqueue_scripts', 'noo_enqueue_mega_menu_js' );

// Function for adding mega menu class to menu items.
if( ! function_exists( 'noo_mega_menu_nav_class' ) ) :
	function noo_mega_menu_nav_class( $classes, $item, $args ) {
		if(property_exists($args,'no_tab_mega')){
			return $classes;
		}
		$noo_header_nav_position = noo_get_option( 'noo_header_nav_position', 'fixed_top' );
// 		$is_vertical_menu = ( $noo_header_nav_position == 'fixed_left' || $noo_header_nav_position == 'fixed_right' );

	    $noo_mega_menu_enable  = noo_get_post_meta( $item->ID, '_noo_mega_menu_enable', 0 );
		$noo_submenu_alignment = noo_get_post_meta( $item->ID, '_noo_submenu_alignment', '' );
		$noo_submenu_direction = noo_get_post_meta( $item->ID, '_noo_submenu_direction', '' );
		$noo_menu_visibility   = noo_get_post_meta( $item->ID, '_noo_menu_visibility', '' );
		$noo_mega_menu_category = noo_get_post_meta( $item->ID, '_noo_mega_menu_category','' );
		if( $noo_mega_menu_enable ) {
			$classes[] = 'megamenu';
			$classes[] = noo_get_post_meta( $item->ID, '_noo_mega_menu_columns', 'columns-3' );
			$classes[] = ( noo_get_post_meta( $item->ID, '_noo_mega_menu_fullheight', 0 ) ? 'fullheight' : '' );
		}

		$noo_mega_menu_submenu = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu', 'normal' );
		$noo_mega_menu_submenu_widget = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu_widget', '' );
		if( $noo_mega_menu_submenu == 'widget' && !empty( $noo_mega_menu_submenu_widget ) ) {
			$classes[] = 'menu-item-has-children widget-submenu';
		}
		$noo_mega_menu_column_span = noo_get_post_meta( $item->ID, '_noo_mega_menu_column_span', '1' );
		if( !empty( $noo_mega_menu_column_span ) && $noo_mega_menu_column_span > '1' ) {
			$classes[] = 'colspan-' . $noo_mega_menu_column_span;
		}

		if( $noo_mega_menu_enable ) {
			$noo_submenu_alignment = ( empty( $noo_submenu_alignment ) ||  $noo_submenu_alignment == 'full-height' ) ? '' : $noo_submenu_alignment;
			if(  !empty( $noo_submenu_alignment )  && empty($noo_mega_menu_category) ) {
				$classes[] = $noo_submenu_alignment;
			}

			if(  !empty( $noo_submenu_direction )) {
				$classes[] = $noo_submenu_direction;
			}
		}

		switch ($noo_menu_visibility) {
		    case 'hidden-phone':
		        $classes[] = ' hidden-xs';
		        break;
		    case 'hidden-tablet':
		        $classes[] = ' hidden-sm hidden-md';
		        break;
		    case 'hidden-pc':
		        $classes[] = ' hidden-lg';
		        break;
		    case 'visible-phone':
		        $classes[] = ' visible-xs-block visible-xs-inline visible-xs-inline-block';
		        break;
		    case 'visible-tablet':
		        $classes[] = ' visible-sm-block visible-sm-inline visible-sm-inline-block visible-md-block visible-md-inline visible-md-inline-block';
		        break;
		    case 'visible-phone':
		        $classes[] = ' visible-lg-block visible-lg-inline visible-lg-inline-block';
		        break;
		}

	    return $classes;
	}
endif;
add_filter( 'nav_menu_css_class', 'noo_mega_menu_nav_class', 10, 3 );

// Function for adding widget menu items.
if( ! function_exists( 'noo_mega_menu_nav_widget' ) ) :
	function noo_mega_menu_nav_widget( $item_output, $item, $depth ) {
		if( $depth != 1 ) {
			return $item_output;
		}

		$noo_mega_menu_submenu = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu', 'normal' );
		$noo_mega_menu_submenu_widget = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu_widget', '' );

		if( $noo_mega_menu_submenu == 'widget' && !empty( $noo_mega_menu_submenu_widget ) && function_exists( 'dynamic_sidebar' ) ) {
			ob_start();
			dynamic_sidebar( $noo_mega_menu_submenu_widget );
			$content = ob_get_clean();
			$item_output .= $content;
		}

	    return $item_output;
	}
endif;
add_filter( 'walker_nav_menu_start_el', 'noo_mega_menu_nav_widget', 10, 3 );

// Function for update additional setting when user save.
if( ! function_exists( 'noo_mega_menu_update_nav_menu_item' ) ) :
	function noo_mega_menu_update_nav_menu_item( $menu_id, $menu_item_db_id ) {
		$noo_mega_menu_enable = isset( $_POST['menu-item-noo-mega-menu-enable'][$menu_item_db_id] ) && $_POST['menu-item-noo-mega-menu-enable'][$menu_item_db_id] == 1;
		update_post_meta( $menu_item_db_id, '_noo_mega_menu_enable', $noo_mega_menu_enable ? 1 : 0 );

		if( $noo_mega_menu_enable ) {
			$noo_mega_menu_columns = isset($_POST['menu-item-noo-mega-menu-columns'][$menu_item_db_id]) ? $_POST['menu-item-noo-mega-menu-columns'][$menu_item_db_id] : '';
			update_post_meta( $menu_item_db_id, '_noo_mega_menu_columns', $noo_mega_menu_columns );
			$noo_mega_menu_fullwidth = isset($_POST['menu-item-noo-mega-menu-fullwidth'][$menu_item_db_id]) ? $_POST['menu-item-noo-mega-menu-fullwidth'][$menu_item_db_id] : '';
			update_post_meta( $menu_item_db_id, '_noo_mega_menu_fullwidth', $noo_mega_menu_fullwidth );
		}
		if(isset($_POST['menu-item-noo-mega-menu-category'][$menu_item_db_id])){
			update_post_meta($menu_item_db_id, '_noo_mega_menu_category', $_POST['menu-item-noo-mega-menu-category'][$menu_item_db_id]);
		}
		$noo_mega_menu_submenu = isset( $_POST['menu-item-noo-mega-menu-submenu'][$menu_item_db_id]) ? $_POST['menu-item-noo-mega-menu-submenu'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_mega_menu_submenu', $noo_mega_menu_submenu);
		$noo_mega_menu_submenu_widget = isset( $_POST['menu-item-noo-mega-menu-submenu-widget'][$menu_item_db_id]) ? $_POST['menu-item-noo-mega-menu-submenu-widget'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_mega_menu_submenu_widget', $noo_mega_menu_submenu_widget);
		$noo_mega_menu_column_span = isset( $_POST['menu-item-noo-mega-menu-column-span'][$menu_item_db_id]) ? $_POST['menu-item-noo-mega-menu-column-span'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_mega_menu_column_span', $noo_mega_menu_column_span);
		
		$noo_submenu_alignment = isset( $_POST['menu-item-noo-submenu-alignment'][$menu_item_db_id] ) ? $_POST['menu-item-noo-submenu-alignment'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_submenu_alignment', $noo_submenu_alignment);
		$noo_submenu_direction = isset( $_POST['menu-item-noo-submenu-direction'][$menu_item_db_id] ) ? $_POST['menu-item-noo-submenu-direction'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_submenu_direction', $noo_submenu_direction );
		$noo_menu_visibility = isset( $_POST['menu-item-noo-menu-visibility'][$menu_item_db_id] ) ? $_POST['menu-item-noo-menu-visibility'][$menu_item_db_id] : '';
		update_post_meta( $menu_item_db_id, '_noo_menu_visibility', $noo_menu_visibility );
	}
endif;
add_action( 'wp_update_nav_menu_item', 'noo_mega_menu_update_nav_menu_item', 10, 2 );

/**
 * Walker Class for adding mega menu settings.
 */

require_once( ABSPATH . 'wp-admin/includes/nav-menu.php' );

if( ! class_exists( 'NOO_Mega_Menu_Nav_Menu_Edit' ) ) :
	class NOO_Mega_Menu_Nav_Menu_Edit extends Walker_Nav_Menu_Edit {
		static $in_mega_menu = false;

		function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			parent::start_el( $output, $item, $depth, $args, $id );

			// Input the option right before Submit Button
			$desc_snipp = '<div class="menu-item-actions description-wide submitbox">';
			$pos = strrpos( $output, $desc_snipp );
			if( $pos !== false ) {
				$output = substr_replace($output, $this->noo_mega_menu_settings( $item, $depth ) . $desc_snipp, $pos, strlen( $desc_snipp ) );
			}
		}

		function noo_mega_menu_settings( $item, $depth = false ) {
			$noo_header_nav_position = noo_get_option( 'noo_header_nav_position', 'fixed_top' );
			$is_vertical_menu      = ( $noo_header_nav_position == 'fixed_left' || $noo_header_nav_position == 'fixed_right' );

			$noo_mega_menu_enable  = noo_get_post_meta( $item->ID, '_noo_mega_menu_enable', 0 );
			$noo_mega_menu_category = noo_get_post_meta( $item->ID, '_noo_mega_menu_category','' );
			$noo_mega_menu_columns = noo_get_post_meta( $item->ID, '_noo_mega_menu_columns', 'columns-3' );
			$noo_mega_menu_submenu = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu', 'normal' );
			$noo_mega_menu_submenu_widget = noo_get_post_meta( $item->ID, '_noo_mega_menu_submenu_widget', '' );
			$noo_mega_menu_column_span = noo_get_post_meta( $item->ID, '_noo_mega_menu_column_span', '1' );

			$noo_mega_menu_fullheight  = noo_get_post_meta( $item->ID, '_noo_mega_menu_fullheight', 0 );

			$noo_submenu_alignment = noo_get_post_meta( $item->ID, '_noo_submenu_alignment', '' );
			$noo_submenu_direction = noo_get_post_meta( $item->ID, '_noo_submenu_direction', '' );
			$noo_menu_visibility   = noo_get_post_meta( $item->ID, '_noo_menu_visibility', '' );

			$html = '<div class="noo-menu-form" >';
			if( $depth == 0 ) {
				// reset mega menu status
				self::$in_mega_menu = $noo_mega_menu_enable;
				if( empty($noo_submenu_alignment) && ( ! $is_vertical_menu )) {
					$noo_submenu_alignment = 'align-left';
				}

				ob_start();
				?>

				<p class="noo-mega-menu-enable description description-wide">
					<label>
						<input <?php checked( $noo_mega_menu_enable, 1 ) ?> type="checkbox" value="1" class="noo-mega-menu-enable" name="menu-item-noo-mega-menu-enable[<?php echo esc_attr($item->ID); ?>]" />
						<?php _e( 'Enable Mega Menu', 'noo' ) ?>
					</label>
				</p>
				<p class="noo-mega-menu-category description description-wide megamenu-child-options" style="display: <?php echo ($noo_mega_menu_enable ? 'block' : 'none') ?>">
					<label for="menu-item-noo-mega-menu-category-<?php echo esc_attr($item->ID); ?>">
						<?php _e( 'Make this a category mega menu', 'noo' ); ?>
						<br/>
						<?php 
						$args = array(
							'orderby'=>'name',
							'depth'=>0,
							'order'=>'ASC',
							'hide_empty'=>0,
							'hierarchical'=>true,
							'value'=>'id',
							'selected'=>$noo_mega_menu_category,
							'walker'=>new Noo_Walker_CategoryDropdown,
							'option_none_value'=>'',
						);
						$categories = get_terms( 'category', $args );
						?>
						<select id="menu-item-noo-mega-menu-category-<?php echo esc_attr($item->ID);?>" name="menu-item-noo-mega-menu-category[<?php echo $item->ID; ?>]">
							<option value=""><?php _e('Select a Category','noo')?></option>
							<?php 
							if(!empty($categories)){
								$args['id']='menu-item-noo-mega-menu-category-'.$item->ID;
								$args['name']='menu-item-noo-mega-menu-category['.$item->ID.'][]';
								echo walk_category_dropdown_tree($categories,0,$args);
							}
							?>
						</select>
					</label>
				</p>
				<p class="noo-mega-menu-columns description description-wide megamenu-child-options" style="display: <?php echo ($noo_mega_menu_enable ? 'block' : 'none') ?>">
					<label for="menu-item-noo-mega-menu-columns-<?php echo esc_attr($item->ID); ?>">
						<?php echo ( $is_vertical_menu ? __( 'Number of Rows', 'noo' ) : __( 'Number of Columns', 'noo' ) ); ?>
						<br/>
						<select id="menu-item-noo-mega-menu-columns-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-mega-menu-columns[<?php echo esc_attr($item->ID); ?>]" class="noo-mega-menu-columns">
							<option <?php selected( 'columns-2', $noo_mega_menu_columns ) ?> value="columns-2"><?php _e( 'Two', 'noo' ) ?></option>
							<option <?php selected( 'columns-3', $noo_mega_menu_columns ) ?> value="columns-3"><?php _e( 'Three', 'noo' ) ?></option>
							<option <?php selected( 'columns-4', $noo_mega_menu_columns ) ?> value="columns-4"><?php _e( 'Four', 'noo' ) ?></option>
							<option <?php selected( 'columns-5', $noo_mega_menu_columns ) ?> value="columns-5"><?php _e( 'Five', 'noo' ) ?></option>
							<option <?php selected( 'columns-6', $noo_mega_menu_columns ) ?> value="columns-6"><?php _e( 'Six', 'noo' ) ?></option>
						</select>
					</label>
				</p>

				<?php if( ! $is_vertical_menu ) : ?>
				<p class="noo-submenu-alignment description description-wide megamenu-child-options" style="display: <?php echo ($noo_mega_menu_enable ? 'block' : 'none') ?>">
					<label for="menu-item-noo-submenu-alignment-<?php echo esc_attr($item->ID); ?>">
						<?php _e( 'Sub-Menu Alignment', 'noo' ); ?>
						<br/>
						<select id="menu-item-noo-submenu-alignment-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-submenu-alignment[<?php echo esc_attr($item->ID); ?>]">
							<option <?php selected( 'full-width', $noo_submenu_alignment ) ?> value="full-width" class="megamenu-child-options" style="display: <?php echo ( $noo_mega_menu_enable ? 'inline' : 'none' ); ?>;"><?php _e( 'Full-width', 'noo' ); ?></option>
							<option <?php selected( 'align-left', $noo_submenu_alignment ) ?> value="align-left"><?php _e( 'Align Left', 'noo' ) ?></option>
							<option <?php selected( 'align-right', $noo_submenu_alignment ) ?> value="align-right"><?php _e( 'Align Right', 'noo' ) ?></option>
							<option <?php selected( 'align-center', $noo_submenu_alignment ) ?> value="align-center"><?php _e( 'Align Center', 'noo' ) ?></option>
						</select>
					</label>
				</p>
				<?php else: ?>
				<p class="noo-mega-menu-fullheight description description-wide" class="megamenu-child-options" style="display: <?php echo ($noo_mega_menu_enable ? 'block' : 'none') ?>">
					<label>
						<input <?php checked( $noo_mega_menu_fullheight, 1 ) ?> type="checkbox" value="1" class="menu-item-noo-mega-menu-fullheight" name="menu-item-noo-mega-menu-fullwidth[<?php echo esc_attr($item->ID); ?>]" />
						<?php _e( 'Full-height Mega Menu', 'noo' ); ?>
					</label>
				</p>
				<?php endif; ?>
				<p class="noo-menu-visibility description description-wide">
					<label for="menu-item-noo-menu-visibility-<?php echo esc_attr($item->ID); ?>">
						<?php _e( 'Visibility', 'noo' ); ?>
						<br/>
						<select id="menu-item-noo-menu-visibility-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-menu-visibility[<?php echo esc_attr($item->ID); ?>]">
							<option <?php selected( '', $noo_menu_visibility ) ?> value="" ><?php _e('All Devices', 'noo'); ?></option>
							<option <?php selected( 'hidden-phone', $noo_menu_visibility ) ?> value="hidden-phone"><?php _e('Hidden Phone', 'noo'); ?></option>
							<option <?php selected( 'hidden-tablet', $noo_menu_visibility ) ?> value="hidden-tablet"><?php _e('Hidden Tablet', 'noo'); ?></option>
							<option <?php selected( 'hidden-pc', $noo_menu_visibility ) ?> value="hidden-pc"><?php _e('Hidden PC', 'noo'); ?></option>
							<option <?php selected( 'visible-phone', $noo_menu_visibility ) ?> value="visible-phone"><?php _e('Visible Phone', 'noo'); ?></option>
							<option <?php selected( 'visible-tablet', $noo_menu_visibility ) ?> value="visible-tablet"><?php _e('Visible Tablet', 'noo'); ?></option>
							<option <?php selected( 'visible-pc', $noo_menu_visibility ) ?> value="visible-pc"><?php _e('Visible PC', 'noo'); ?></option>
						</select>
					</label>
				</p>
				<input type="hidden" name="menu-item-noo-submenu-direction[<?php echo esc_attr($item->ID); ?>]" value="" />

				<?php
				$html .= ob_get_clean();
			} else {
				if( empty($noo_submenu_direction) && ( ! $is_vertical_menu ) ) {
					$noo_submenu_direction = 'fly-right';
				}
				ob_start();
				?>

				<?php if( $depth == 1 ) : 
					$widget_list = smk_get_all_sidebars();
				?>
					<p class="noo-mega-menu-column-span description description-wide">
						<label for="menu-item-noo-mega-menu-column-span-<?php echo esc_attr($item->ID); ?>">
							<?php _e( 'Column Span', 'noo' ); ?>
							<br/>
							<select id="menu-item-noo-mega-menu-column-span-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-mega-menu-column-span[<?php echo esc_attr($item->ID); ?>]" class="noo-mega-menu-column-span">
								<option <?php selected( '1', $noo_mega_menu_column_span ) ?> value="1" <?php echo 'style="display: ' . ( $noo_mega_menu_columns >= 1 ? 'block' : 'none' ) . '"'; ?>><?php echo '1 ' . __('col', 'noo'); ?></option>
								<?php for( $index = 2; $index <= 6; $index++ ) : ?>
								<option <?php selected( $index, $noo_mega_menu_column_span ) ?> value="<?php echo ( $index ); ?>" <?php echo 'style="display: ' . ( $noo_mega_menu_columns >= $index ? 'block' : 'none' ) . '"'; ?>><?php echo ( $index ) . ' ' . __('cols', 'noo'); ?></option>
								<?php endfor; ?>
							</select>
						</label>
					</p>
					<p class="noo-mega-menu-submenu description description-wide">
						<label for="menu-item-noo-mega-menu-submenu-<?php echo esc_attr($item->ID); ?>">
							<?php _e( 'Submenu Type', 'noo' ); ?>
							<br/>
							<select id="menu-item-noo-mega-menu-submenu-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-mega-menu-submenu[<?php echo esc_attr($item->ID); ?>]" class="noo-mega-menu-submenu">
								<option <?php selected( 'normal', $noo_mega_menu_submenu ) ?> value="normal"><?php _e( 'Normal Submenu', 'noo' ) ?></option>
								<option <?php selected( 'widget', $noo_mega_menu_submenu ) ?> value="widget"><?php _e( 'Widget Area', 'noo' ) ?></option>
							</select>
						</label>
					</p>
					<p class="noo-mega-menu-submenu-widget description description-wide submenu-type-child-options" style="display: <?php echo ($noo_mega_menu_submenu == 'widget' ? 'block' : 'none') ?>">
						<label for="menu-item-noo-mega-menu-submenu-widget-<?php echo esc_attr($item->ID); ?>">
							<?php _e( 'Select Widget Area', 'noo' ); ?>
							<br/>
							<select id="menu-item-noo-mega-menu-submenu-widget-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-mega-menu-submenu-widget[<?php echo esc_attr($item->ID); ?>]" class="noo-mega-menu-submenu-widget">
								<?php foreach ( $widget_list as $widget_id => $name ) {
									echo'<option value="' . $widget_id . '"';
									if ( $noo_mega_menu_submenu_widget == $widget_id ) echo ' selected="selected"';
									echo '>' . $name . '</option>';
								}?>
							</select>
						</label>
					</p>
				<?php else : ?>
				<input type="hidden" value="" name="menu-item-noo-mega-menu-column-span[<?php echo esc_attr($item->ID); ?>]" />
				<input type="hidden" value="" name="menu-item-noo-mega-menu-submenu[<?php echo esc_attr($item->ID); ?>]" />
				<input type="hidden" value="" name="menu-item-noo-mega-menu-submenu-widget[<?php echo esc_attr($item->ID); ?>]" />
				<?php endif; ?>
				<?php if( self::$in_mega_menu || $is_vertical_menu ) : ?>
				<input type="hidden" value="" name="menu-item-noo-submenu-direction[<?php echo esc_attr($item->ID); ?>]" />
				<?php else : ?>
				<p class="noo-submenu-direction description description-wide">
					<label for="menu-item-noo-submenu-direction-<?php echo esc_attr($item->ID); ?>">
						<?php _e( 'Flying Direction for Sub-Menu of this Item', 'noo' ); ?>
						<br/>
						<select id="menu-item-noo-submenu-direction-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-submenu-direction[<?php echo esc_attr($item->ID); ?>]">
							<option <?php selected( 'fly-left', $noo_submenu_direction ) ?> value="fly-left"><?php _e( 'Fly Left', 'noo' ) ?></option>
							<option <?php selected( 'fly-right', $noo_submenu_direction ) ?> value="fly-right"><?php _e( 'Fly Right', 'noo' ) ?></option>
						</select>
					</label>
				</p>
				<?php endif; ?>
				<p class="noo-menu-visibility description description-wide">
					<label for="menu-item-noo-menu-visibility-<?php echo esc_attr($item->ID); ?>">
						<?php _e( 'Visibility', 'noo' ); ?>
						<br/>
						<select id="menu-item-noo-menu-visibility-<?php echo esc_attr($item->ID); ?>" name="menu-item-noo-menu-visibility[<?php echo esc_attr($item->ID); ?>]">
							<option <?php selected( '', $noo_menu_visibility ) ?> value="" ><?php _e('All Devices', 'noo'); ?></option>
							<option <?php selected( 'hidden-phone', $noo_menu_visibility ) ?> value="hidden-phone"><?php _e('Hidden Phone', 'noo'); ?></option>
							<option <?php selected( 'hidden-tablet', $noo_menu_visibility ) ?> value="hidden-tablet"><?php _e('Hidden Tablet', 'noo'); ?></option>
							<option <?php selected( 'hidden-pc', $noo_menu_visibility ) ?> value="hidden-pc"><?php _e('Hidden PC', 'noo'); ?></option>
							<option <?php selected( 'visible-phone', $noo_menu_visibility ) ?> value="visible-phone"><?php _e('Visible Phone', 'noo'); ?></option>
							<option <?php selected( 'visible-tablet', $noo_menu_visibility ) ?> value="visible-tablet"><?php _e('Visible Tablet', 'noo'); ?></option>
							<option <?php selected( 'visible-pc', $noo_menu_visibility ) ?> value="visible-pc"><?php _e('Visible PC', 'noo'); ?></option>
						</select>
					</label>
				</p>
				<input type="hidden" value="0" name="menu-item-noo-mega-menu-enable[<?php echo esc_attr($item->ID); ?>]" />
				<input type="hidden" value="" name="menu-item-noo-mega-menu-columns[<?php echo esc_attr($item->ID); ?>]" />
				<input type="hidden" value="" name="menu-item-noo-mega-menu-fullwidth[<?php echo esc_attr($item->ID); ?>]" />
				<input type="hidden" value="" name="menu-item-noo-submenu-alignment[<?php echo esc_attr($item->ID); ?>]" />

				<?php
				$html .= ob_get_clean();
			}

			$html .= '</div>';

			return $html;
		}
	}
endif;

add_filter( 'wp_edit_nav_menu_walker', create_function( '', 'return "NOO_Mega_Menu_Nav_Menu_Edit";' ) );

function noo_nav_menu_objects($items, $args = '') {
	$menus = array();
	foreach ($items as &$item) {
		$item->_noo_cat_mega_menu = false;
		$noo_mega_menu_enable  = noo_get_post_meta( $item->ID, '_noo_mega_menu_enable', 0 );
		if($noo_mega_menu_enable){
			$noo_mega_menu_category = noo_get_post_meta( $item->ID, '_noo_mega_menu_category','' );
			if(!empty($noo_mega_menu_category)){
				if(property_exists($args,'no_tab_mega')){
					$item->classes[] = 'menu-item-has-children';
					$menus[] = $item;
					$category = get_category($noo_mega_menu_category);
					if(!empty($category) && !is_wp_error($category)){
						$new_item = noo_post_class_temp();
						$new_item->_noo_mega_menu_enable = false;
						$new_item->_noo_cat_mega_menu = false;
						$new_item->menu_item_parent = $item->ID;
						$new_item->url = get_category_link($category);
						$new_item->title = $category->name;
						$menus[] = $new_item;
					}
					$child_categories = get_categories(array('child_of'=>$category->term_id));
					if(!is_wp_error($child_categories) && !empty($child_categories)){
						$c=0;
						foreach ($child_categories as $child_category){
							if($c == 5)
								break;
							$new_item = noo_post_class_temp();
							$new_item->_noo_mega_menu_enable = false;
							$new_item->_noo_cat_mega_menu = false;
							$new_item->menu_item_parent = $item->ID;
							$new_item->url = get_category_link($child_category);
							$new_item->title = $child_category->name;
							$menus[] = $new_item;
						}
					}
					
				}else{
					$item->classes[] = 'full-100-width';
					$menus[] = $item;
			        $new_item = noo_post_class_temp();
			        $new_item->_noo_mega_menu_enable = true;
			        $new_item->_noo_cat_mega_menu = true;
			        $new_item->menu_item_parent = $item->ID;
			        $new_item->url = '';
			        $new_item->title = noo_cat_mega_menu_output(array(
			        	'cat_id'	=>$noo_mega_menu_category,
			        	'post_count'=>7,
			        	'show_child'=>5,
			        	'column'	=>4,
			        ));
			        $menus[] = $new_item;
				}
			}else{
				$menus[] = $item;
			}
		}else{
			$menus[] = $item;
		}
	}
	return $menus;
}
add_filter('wp_nav_menu_objects', 'noo_nav_menu_objects',  10, 2);

function noo_post_class_temp(){
	$post = new stdClass;
	$post->ID = 0;
	$post->post_author = '';
	$post->post_date = '';
	$post->post_date_gmt = '';
	$post->post_password = '';
	$post->post_type = 'noo_mega_menu_cat';
	$post->post_status = 'draft';
	$post->to_ping = '';
	$post->pinged = '';
	$post->comment_status = '';
	$post->ping_status = '';
	$post->post_pingback = '';
	$post->post_category = '';
	$post->page_template = 'default';
	$post->post_parent = 0;
	$post->menu_order = 0;
	return new WP_Post($post);
}

function noo_cat_mega_menu_output($args=''){
	$defaults = array(
		'cat_id'	=>0,
		'post_count'=>5,
		'show_child'=>5,
		'column'	=>4,
	);
	$args = wp_parse_args($args,$defaults);
	extract($args);
	if(empty($cat_id)){
		return __('No Category','noo');
	}
	ob_start();
	$category = get_category($cat_id);
	$child_categories = array();
	if(!$category || is_wp_error($category)){
		return __('Not found Category','noo');
	}
	?>
	<div class="cat-mega-menu container-boxed">
		<div class="cat-mega-menu-wrap clearfix">
			<div class="cat-mega-filters">
				<ul>
					<li class="selected"><a class="cat-mega-filter" data-cat-id="<?php echo esc_attr($category->term_id)?>" href="<?php echo get_category_link($category)?>"><?php echo sprintf(__('All %s','noo'),$category->name) ?></a></li>
					<?php 
					if(!empty($show_child)){
						$child_categories = get_categories(array('child_of'=>$category->term_id));
						if(!is_wp_error($child_categories) && !empty($child_categories)){
							foreach ($child_categories as $child_category):
					?>
						<li><a class="cat-mega-filter" data-cat-id="<?php echo esc_attr($child_category->term_id)?>" href="<?php echo get_category_link($child_category)?>"><?php echo esc_html($child_category->name) ?></a></li>
					<?php
							endforeach;
						}
					}
					?>
				</ul>
			</div>
			<div class="cat-mega-contents">
				<?php 
				$cat_posts = get_posts(array(
					'cat'=>$cat_id,
					'ignore_sticky_posts'=>true,
					'posts_per_page'=>$post_count,
					'meta_key' => '_thumbnail_id',
				));
				if(!empty($cat_posts)):
				$count_posts = count($cat_posts);
				?>
				<div data-control-id="cat-mega-<?php echo esc_attr($category->term_id)?>" class="cat-mega-content clearfix" style="display:block">
					<div class="cat-mega-intro">
						<?php for($i =0;$i<1;$i++):?>
							<?php $post = $cat_posts[$i]?>
							<a href="<?php echo get_the_permalink($post)?>">
								<?php echo get_the_post_thumbnail($post->ID,'noo-thumbnail-square');?>
							</a>
							<h3>
								<a href="<?php echo get_the_permalink($post)?>">
									<?php echo get_the_title($post)?>
								</a>
							</h3>
						<?php endfor;?>
					</div>
					<?php if($count_posts > 1){?>
					<div class="cat-mega-extra">
						<?php 
						$ex_count = absint($post_count) - 1;
						if($count_posts < $ex_count){
							$ex_count = $count_posts;
						};
						?>
						<?php $c= 0;?>
						<?php for($i = 1; $i< $ex_count;$i++):?>
							<?php if($c ++ % 3 == 0):?>
							<div class="cat-mega-extra-row clearfix">
							<?php endif;?>
								<div class="cat-mega-extra-item">
									<?php $post = $cat_posts[$i]?>
									<a href="<?php echo get_the_permalink($post)?>">
										<?php echo get_the_post_thumbnail($post->ID,'noo-thumbnail-square');?>
									</a>
									<h3>
										<a href="<?php echo get_the_permalink($post)?>">
											<?php echo get_the_title($post)?>
										</a>
									</h3>
								</div>
							<?php if($c % 3 == 0 || $c == ($ex_count - 1)):?>
							</div>
							<?php endif;?>
						<?php endfor;?>
					</div>
					<?php }?>
				</div>
				<?php endif;?>
				<?php 
				if(!empty($child_categories) ){
					foreach ($child_categories as $child_category):
					?>
					<?php 
					$child_cat_posts = get_posts(array(
						'cat'=>$child_category->term_id,
						'ignore_sticky_posts'=>true,
						'posts_per_page'=>$post_count,
						'meta_key' => '_thumbnail_id',
					));
					if(!empty($child_cat_posts)):
					$count_posts = count($child_cat_posts);
					?>
					<div data-control-id="cat-mega-<?php echo esc_attr($child_category->term_id)?>" class="cat-mega-content clearfix" style="display: none">
						<div class="cat-mega-intro">
							<?php for($i = 0; $i<1 ;$i++):?>
								<?php $post = $child_cat_posts[$i]?>
								<a href="<?php echo get_the_permalink($post)?>">
									<?php echo get_the_post_thumbnail($post->ID,'noo-thumbnail-square');?>
								</a>
								<h3>
									<a href="<?php echo get_the_permalink($post)?>">
										<?php echo get_the_title($post)?>
									</a>
								</h3>
							<?php endfor;?>
						</div>
						<?php if($count_posts > 1){?>
						<div class="cat-mega-extra">
							<?php 
							$ex_count = absint($post_count) - 1;
							if($count_posts < $ex_count){
								$ex_count = $count_posts;
							}
							?>
							<?php $c = 0;?>
							<?php for($i = 1;$i < $ex_count;$i++):?>
								<?php if($c ++ % 3 == 0):?>
								<div class="cat-mega-extra-row clearfix">
								<?php endif;?>
									<div class="cat-mega-extra-item">
										<?php $post = $child_cat_posts[$i]?>
										<a href="<?php echo get_the_permalink($post)?>">
											<?php echo get_the_post_thumbnail($post->ID,'noo-thumbnail-square');?>
										</a>
										<h3>
											<a href="<?php echo get_the_permalink($post)?>">
												<?php echo get_the_title($post)?>
											</a>
										</h3>
									</div>
								<?php if($c % 3 == 0 || $c == ($ex_count - 1)):?>
								</div>
								<?php endif;?>
							<?php endfor;?>
						</div>
						<?php }?>
					</div>
					<?php endif;?>
				<?php 
					endforeach;
				}
				?>
			</div>
		</div>
	</div>
	<?php
	return ob_get_clean();
}

class Noo_Walker_Mega_Menu extends Walker_Nav_Menu{
	
	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
	
		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;
	
		/**
		 * Filter the CSS class(es) applied to a menu item's list item element.
		 *
		 * @since 3.0.0
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param array  $classes The CSS classes that are applied to the menu item's `<li>` element.
		 * @param object $item    The current menu item.
		 * @param array  $args    An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth   Depth of menu item. Used for padding.
		 */
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';
	
		/**
		 * Filter the ID applied to a menu item's list item element.
		 *
		 * @since 3.0.1
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param string $menu_id The ID that is applied to the menu item's `<li>` element.
		 * @param object $item    The current menu item.
		 * @param array  $args    An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth   Depth of menu item. Used for padding.
		 */
		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';
	
		$output .= $indent . '<li' . $id . $class_names .'>';
	
		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
		$atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
		$atts['href']   = ! empty( $item->url )        ? $item->url        : '';
	
		/**
		 * Filter the HTML attributes applied to a menu item's anchor element.
		 *
		 * @since 3.6.0
		 * @since 4.1.0 The `$depth` parameter was added.
		 *
		 * @param array $atts {
		 *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
		 *
		 *     @type string $title  Title attribute.
		 *     @type string $target Target attribute.
		 *     @type string $rel    The rel attribute.
		 *     @type string $href   The href attribute.
		 * }
		 * @param object $item  The current menu item.
		 * @param array  $args  An array of {@see wp_nav_menu()} arguments.
		 * @param int    $depth Depth of menu item. Used for padding.
		 */
		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );
	
		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}
	
		$item_output = $args->before;
		if(false == $item->_noo_cat_mega_menu)
			$item_output .= '<a'. $attributes .'>';
		/** This filter is documented in wp-includes/post-template.php */
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		if(false == $item->_noo_cat_mega_menu)
			$item_output .= '</a>';
		$item_output .= $args->after;
	
		/**
		 * Filter a menu item's starting output.
		 *
		 * The menu item's starting output only includes `$args->before`, the opening `<a>`,
		 * the menu item's title, the closing `</a>`, and `$args->after`. Currently, there is
		 * no filter for modifying the opening and closing `<li>` for a menu item.
		 *
		 * @since 3.0.0
		 *
		 * @param string $item_output The menu item's starting HTML output.
		 * @param object $item        Menu item data object.
		 * @param int    $depth       Depth of menu item. Used for padding.
		 * @param array  $args        An array of {@see wp_nav_menu()} arguments.
		 */
		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}
