<?php
/**
 * Utilities Functions for NOO Framework.
 * This file contains various functions for getting and preparing data.
 *
 * @package    NOO Framework
 * @version    1.0.0
 * @author     Kan Nguyen <khanhnq@nootheme.com>
 * @copyright  Copyright (c) 2014, NooTheme
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       http://nootheme.com
 */

if (!function_exists('get_page_layout')):
	function get_page_layout() {
		$layout = 'fullwidth';

		// Normal Page or Static Front Page
		if (is_page() || (is_front_page() && get_option('show_on_front') == 'page')) {
			// WP page,
			// get the page template setting
			$page_id = get_the_ID();
			$page_template = noo_get_post_meta($page_id, '_wp_page_template', 'default');
			
			if (strpos($page_template, 'sidebar') !== false) {
				if (strpos($page_template, 'left') !== false) {
					$layout = 'left_sidebar';
				}
				
				$layout = 'sidebar';
			}
		}

		// WooCommerce
		if( NOO_WOOCOMMERCE_EXIST ) {
			if( is_shop() || is_product_category() || is_product_tag() ){
				$layout = noo_get_option('noo_shop_layout', 'fullwidth');
				return apply_filters( 'noo_page_layout', $layout );
			}
			if( is_product() ) {
				$product_layout = noo_get_option('noo_woocommerce_product_layout', 'same_as_shop');
				if ($product_layout == 'same_as_shop') {
					$product_layout = noo_get_option('noo_shop_layout', 'fullwidth');
				}
				$layout = $product_layout;
				return apply_filters( 'noo_page_layout', $layout );
			}
			
		}

		global $noo_post_types;
		if( !empty( $noo_post_types ) ) {
			foreach ($noo_post_types as $post_type => $args) {
				if( noo_is_archive( $post_type ) ) {
					if( isset( $args['customizer'] ) ) {
						if( in_array( 'layout', $args['customizer'] ) || in_array( 'list-layout', $args['customizer'] ) ) {
							$layout = noo_get_option("{$post_type}_archive_layout");
						}
					}

					break;
				}
				
				if( is_singular( $post_type ) ) {
					if( isset( $args['customizer'] ) ) {
						if( in_array( 'single-layout', $args['customizer'] ) ) {
							$layout = noo_get_option("{$post_type}_single_layout");
						}

						if( $layout == 'same_as_archive' ) {
							if( in_array( 'layout', $args['customizer'] ) || in_array( 'list-layout', $args['customizer'] ) ) {
								$layout = noo_get_option("{$post_type}_archive_layout");
							} else {
								$layout = 'fullwidth';
							}
						}
					}

					break;
				}
			}
		}
		
		// Single post page
		if (is_single()) {

			// WP post,
			// check if there's overrode setting in this post.
			$post_id = get_the_ID();
			$override_setting = noo_get_post_meta($post_id, '_noo_wp_post_override_layout', false);
			
			if ( !$override_setting ) {
				$post_layout = noo_get_option('noo_blog_post_layout', 'same_as_blog');
				if ($post_layout == 'same_as_blog') {
					$post_layout = noo_get_option('noo_blog_layout', 'sidebar');
				}
				$layout = $post_layout;
			}

			// overrode
			$layout = noo_get_post_meta($post_id, '_noo_wp_post_layout', 'sidebar-main');
		}

		// Index or Home
		if (is_home() || is_archive() || (is_front_page() && get_option('show_on_front') == 'posts')) {
			
			$layout = noo_get_option('noo_blog_layout', 'sidebar');
		}
		
		return apply_filters( 'noo_page_layout', $layout );
	}
endif;

if(!function_exists('is_fullwidth')){
	function is_fullwidth(){
		return get_page_layout() == 'fullwidth';
	}
}

if (!function_exists('is_one_page_enabled')):
	function is_one_page_enabled() {
		if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
			$page_id = get_the_ID();
			return ( noo_get_post_meta( $page_id, '_noo_wp_page_enable_one_page', false ) );
		}

		return false;
	}
endif;

if (!function_exists('get_one_page_menu')):
	function get_one_page_menu() {
		if( is_one_page_enabled() ) {
			if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
				$page_id = get_the_ID();
				return noo_get_post_meta( $page_id, '_noo_wp_page_one_page_menu', '' );
			}
		}

		return '';
	}
endif;

if (!function_exists('has_home_slider')):
	function has_home_slider() {
		if (class_exists( 'RevSlider' )) {
			if( (is_front_page() && get_option('show_on_front' == 'page')) || is_page()) {
				$page_id = get_the_ID();
				return ( noo_get_post_meta( $page_id, '_noo_wp_page_enable_home_slider', false ) )
					&& ( noo_get_post_meta( $page_id, '_noo_wp_page_slider_rev', '' ) != '' );
			}
		}

		return false;
	}
endif;

if (!function_exists('get_sidebar_id')):
	function get_sidebar_id() {
		$sidebar = '';

		// Normal Page or Static Front Page
		if ( is_page() || (is_front_page() && get_option('show_on_front') == 'page') ) {
			// Get the sidebar setting from
			$sidebar = noo_get_post_meta(get_the_ID(), '_noo_wp_page_sidebar', '');
		}

		// WooCommerce Product
		if( NOO_WOOCOMMERCE_EXIST ) {
			if( is_product() ) {
				$product_layout = noo_get_option('noo_woocommerce_product_layout', 'same_as_shop');
				$sidebar = '';
				if ( $product_layout == 'same_as_shop' ) {
					$product_layout = noo_get_option('noo_shop_layout', 'fullwidth');
					$sidebar = noo_get_option('noo_shop_sidebar', '');
				} else {
					$sidebar = noo_get_option('noo_woocommerce_product_sidebar', '');
				}
				
				if ( $product_layout == 'fullwidth' ) {
					$sidebar = '';
				}
				return $sidebar;
			}

			// Shop, Product Category, Product Tag, Cart, Checkout page
			if( is_shop() || is_product_category() || is_product_tag() ) {
				$shop_layout = noo_get_option('noo_shop_layout', 'fullwidth');
				if($shop_layout != 'fullwidth'){
					$sidebar = noo_get_option('noo_shop_sidebar', '');
				}
				return $sidebar;
			}

		}

		global $noo_post_types;
		if( !empty( $noo_post_types ) ) {
			foreach ($noo_post_types as $post_type => $args) {
				if( noo_is_archive( $post_type ) ) {
					if( isset( $args['customizer'] ) ) {
						if( in_array( 'layout', $args['customizer'] ) || in_array( 'list-layout', $args['customizer'] ) ) {
							$layout = noo_get_option("{$post_type}_archive_layout", 'fullwidth');
							if( $layout != 'fullwidth' ) {
								$sidebar = noo_get_option("{$post_type}_archive_sidebar", 'sidebar-main');
							}
						}
					}

					break;
				}
				
				if( is_singular( $post_type ) ) {
					if( isset( $args['customizer'] ) ) {
						if( in_array( 'single-layout', $args['customizer'] ) ) {
							$layout = noo_get_option("{$post_type}_single_layout");
							if( $layout != 'fullwidth' ) {
								$sidebar = noo_get_option("{$post_type}_single_sidebar", 'sidebar-main');
							}
						}

						if( $layout == 'same_as_archive' ) {
							if( in_array( 'layout', $args['customizer'] ) || in_array( 'list-layout', $args['customizer'] ) ) {
								$sidebar = noo_get_option("{$post_type}_archive_sidebar", 'sidebar-main');
							}
						}
					}

					break;
				}
			}
		}
		
		// Single post page
		if (is_single()) {
			// Check if there's overrode setting in this post.
			$post_id = get_the_ID();
			$override_setting = noo_get_post_meta($post_id, '_noo_wp_post_override_layout', false);
			if ($override_setting) {
				// overrode
				$overrode_layout = noo_get_post_meta($post_id, '_noo_wp_post_layout', 'fullwidth');
				if ($overrode_layout != 'fullwidth') {
					$sidebar = noo_get_post_meta($post_id, '_noo_wp_post_sidebar', 'sidebar-main');
				}
			} else{

				$post_layout = noo_get_option('noo_blog_post_layout', 'same_as_blog');
				$sidebar = '';
				if ($post_layout == 'same_as_blog') {
					$post_layout = noo_get_option('noo_blog_layout', 'sidebar');
					$sidebar = noo_get_option('noo_blog_sidebar', 'sidebar-main');
				} else {
					$sidebar = noo_get_option('noo_blog_post_sidebar', 'sidebar-main');
				}
				
				if($post_layout == 'fullwidth'){
					$sidebar = '';
				}
			}
		}

		// Archive, Index or Home
		if (is_home() || is_archive() || (is_front_page() && get_option('show_on_front') == 'posts')) {
			
			$blog_layout = noo_get_option('noo_blog_layout', 'sidebar');
			if ($blog_layout != 'fullwidth') {
				$sidebar = noo_get_option('noo_blog_sidebar', 'sidebar-main');
			}
		}
		
		return apply_filters( 'noo_sidebar_id', $sidebar );
	}
endif;

if (!function_exists('smk_get_all_sidebars')):
	function smk_get_all_sidebars() {
		global $wp_registered_sidebars;
		$sidebars = array();
		$none_sidebars = array();
		for ($i = 1;$i <= 4;$i++) {
			$none_sidebars[] = "noo-top-{$i}";
			$none_sidebars[] = "noo-footer-{$i}";
		}
		if ($wp_registered_sidebars && !is_wp_error($wp_registered_sidebars)) {
			
			foreach ($wp_registered_sidebars as $sidebar) {
				// Don't include Top Bar & Footer Widget Area
				if (in_array($sidebar['id'], $none_sidebars)) continue;
				
				$sidebars[$sidebar['id']] = $sidebar['name'];
			}
		}
		return $sidebars;
	}
endif;

if (!function_exists('get_sidebar_name')):
	function get_sidebar_name($id = '') {
		if (empty($id)) return '';
		
		global $wp_registered_sidebars;
		if ($wp_registered_sidebars && !is_wp_error($wp_registered_sidebars)) {
			foreach ($wp_registered_sidebars as $sidebar) {
				if ($sidebar['id'] == $id) return $sidebar['name'];
			}
		}
		
		return '';
	}
endif;

if (!function_exists('noo_get_page_link_by_template')):
	function noo_get_page_link_by_template( $page_template ) {
		$pages = get_pages(array(
			'meta_key' => '_wp_page_template',
			'meta_value' => $page_template
		));

		if( $pages ){
			$link = get_permalink( $pages[0]->ID );
		}else{
			$link = home_url();
		}
		return $link;
	}
endif;

/**
 * This function is original from Visual Composer. Redeclare it here so that it could be used for site without VC.
 */
if ( !function_exists('noo_handler_shortcode_content') ):
	function noo_handler_shortcode_content( $content, $autop = false ) {
		if ( $autop ) {
			$content = wpautop( preg_replace( '/<\/?p\>/', "\n", $content ) . "\n" );
		}
		return do_shortcode( shortcode_unautop( $content) );
	}
endif;

// Allow only unharmed HTML tag.
if( !function_exists('noo_html_content_filter') ) :
	function noo_html_content_filter( $content = '' ) {
		$allowed_html = array(
			'a' => array(
				'href' => array(),
				'target' => array(),
				'title' => array(),
				'rel' => array(),
				'class' => array(),
				'style' => array(),
			),
			'img' => array(
				'src' => array(),
				'class' => array(),
				'style' => array(),
			),
			'h1' => array(),
			'h2' => array(),
			'h3' => array(),
			'h4' => array(),
			'h5' => array(),
			'p' => array(
				'class' => array(),
				'style' => array()
			),
			'br' => array(
				'class' => array(),
				'style' => array()
			),
			'hr' => array(
				'class' => array(),
				'style' => array()
			),
			'span' => array(
				'class' => array(),
				'style' => array()
			),
			'em' => array(
				'class' => array(),
				'style' => array()
			),
			'strong' => array(
				'class' => array(),
				'style' => array()
			),
			'small' => array(
				'class' => array(),
				'style' => array()
			),
			'b' => array(
				'class' => array(),
				'style' => array()
			),
			'i' => array(
				'class' => array(),
				'style' => array()
			),
			'u' => array(
				'class' => array(),
				'style' => array()
			),
			'ul' => array(
				'class' => array(),
				'style' => array()
			),
			'ol' => array(
				'class' => array(),
				'style' => array()
			),
			'li' => array(
				'class' => array(),
				'style' => array()
			),
			'blockquote' => array(
				'class' => array(),
				'style' => array()
			),
		);

		$allowed_html = apply_filters( 'noo_allowed_html', $allowed_html );

		return wp_kses( $content, $allowed_html );
	}
endif;

// Backwards compatibility for wp_title
if ( ! function_exists( '_wp_render_title_tag' ) ) {
	function noo_render_title() {
?>
<title><?php wp_title( '|', true, 'right' ); ?></title>
<?php
	}
	add_action( 'wp_head', 'noo_render_title' );
}