<?php
// Variables
$default_primary_color = noo_get_theme_default( 'primary_color' );
$noo_typo_headings_font = $noo_typo_use_custom_fonts ? noo_get_option( 'noo_typo_headings_font', noo_get_theme_default( 'headings_font_family' ) ) : noo_get_theme_default( 'headings_font_family' );

$default_header_bg_color = noo_get_theme_default( 'header_bg' );
$default_nav_font_size = noo_get_theme_default( 'font_size' );
$default_font_color = noo_get_theme_default( 'text_color' );
$default_font = noo_get_theme_default( 'font_family' );
$default_logo_font_color = noo_get_theme_default( 'logo_color' );

$noo_header_bg_color = noo_get_option( 'noo_header_bg_color', $default_header_bg_color );

$noo_header_nav_position = noo_get_option( 'noo_header_nav_position', 'fixed_top' );

$noo_header_nav_icon_cart   = noo_get_option( 'noo_header_nav_icon_cart', false );

$noo_header_custom_nav_font = noo_get_option( 'noo_header_custom_nav_font', false );

$noo_header_nav_font = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_font', $noo_typo_headings_font ) : $noo_typo_headings_font;
$noo_header_nav_font_style = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_font_style', 'normal' ) : 'normal';
$noo_header_nav_font_weight = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_font_weight', 'bold' ) : 'bold';
$noo_header_nav_font_subset = $noo_header_custom_nav_font ? noo_get_option( 'noo_header_nav_font_subset', 'latin' ) : 'latin';
$noo_header_nav_font_size = noo_get_option( 'noo_header_nav_font_size', $default_nav_font_size );
$noo_header_nav_uppercase = noo_get_option( 'noo_header_nav_uppercase', true );

$noo_header_use_image_logo = noo_get_option( 'noo_header_use_image_logo', false );

$noo_header_logo_font = noo_get_option( 'noo_header_logo_font', noo_get_theme_default( 'logo_font_family' ) );
$noo_header_logo_font_size = noo_get_option( 'noo_header_logo_font_size', '50' );
$noo_header_logo_font_color = noo_get_option( 'noo_header_logo_font_color', '#fff' );
$noo_header_logo_font_style = noo_get_option( 'noo_header_logo_font_style', 'normal' );
$noo_header_logo_font_weight = noo_get_option( 'noo_header_logo_font_weight', '700' );
$noo_header_logo_font_subset = noo_get_option( 'noo_header_logo_font_subset', 'latin' );
$noo_header_logo_uppercase = noo_get_option( 'noo_header_logo_uppercase', false );

$noo_header_logo_image_height = noo_get_option( 'noo_header_logo_image_height', '70' );

$noo_header_nav_height = noo_get_option( 'noo_header_nav_height', '70' );
$noo_header_nav_link_spacing = noo_get_option( 'noo_header_nav_link_spacing', '10' );

$noo_header_nav_toggle_size = noo_get_option( 'noo_header_nav_toggle_size', '25' );

?>

/* Header */
/* ====================== */
<?php if ( $noo_header_bg_color != '' ) : ?>
<!-- .noo-header {
	background-color: <?php echo esc_html($noo_header_bg_color); ?>;
} -->
<?php endif; ?>

/* Navigation Typography */
/* ====================== */

/* NavBar: Typo */
.navbar-nav li > a {
	font-family: "<?php echo esc_html($noo_header_nav_font); ?>", sans-serif;
	font-size: <?php echo esc_html($noo_header_nav_font_size) . 'px'; ?>;
}

.navbar {
	min-height: <?php echo esc_html($noo_header_nav_height) . 'px'; ?>;
}

/* Logo */
/* ====================== */
<?php if( ! $noo_header_use_image_logo ) : ?>
.navbar-brand {
	color: <?php echo esc_html($noo_header_logo_font_color); ?>;
	font-family: "<?php echo esc_html($noo_header_logo_font); ?>", sans-serif;
	font-size: <?php echo esc_html($noo_header_logo_font_size) . 'px'; ?>;
	font-style: <?php echo esc_html($noo_header_logo_font_style); ?>;
	font-weight: <?php echo esc_html($noo_header_logo_font_weight); ?>;
	<?php if ( !empty( $noo_header_logo_uppercase ) ) : ?>
	text-transform: uppercase;
	<?php else: ?>
	text-transform: none;
	<?php endif; ?>
}
<?php else : ?>
.navbar-brand .noo-logo-img,
.navbar-brand .noo-logo-retina-img {
	max-height: <?php echo esc_html($noo_header_logo_image_height) . 'px'; ?>;
}
<?php endif; ?>

/* Mobile Icons */
/* ====================== */
.navbar-toggle, .mobile-minicart-icon {
	font-size: <?php echo esc_html($noo_header_nav_toggle_size) . 'px'; ?>;
}